using System;
using System.Web;
using Meta.Web.Controls.MasterPages;   

namespace MetaSite.Components.Controls
{
	/// <summary>
	/// PageHead
	/// </summary>
	public class PageHead : Meta.Web.Controls.MasterPages.HtmlHeader    
	{
		public const string key = "pagetitle";
		public PageHead() : base()
		{
			string key="site-name";
			string title;
			object o = Meta.Web.CacheData.Get(key);  
			if ( o!=null)
				title = o.ToString();
			else
			{
				title = Meta.Web.Configuration.Settings.AppSettings.Get("sitename"); 
				title = (title==null || title ==string.Empty)? "Meta Site":title;
				Meta.Web.CacheData.Insert(key,title);
			}		
			
			this.Title = title;//<META http-equiv=Content-Type content="text/html; charset=gb2312">
           // this.AddVSDefault();
           // this.AddMeta(AddMetaStyle.Content_Type, "text/html; charset=gb2312");
            AddStyleScript();			
		}

        protected  virtual void AddStyleScript()
        {
            //this.AddStyle("../style/common.css");              
        }

		public string Get(HttpContext context)
		{
			string title = context.Items[key] as string;
			return (title == null) ? this.Title : title;
		}

		protected override void Render(System.Web.UI.HtmlTextWriter writer)
		{
            this.Title = Get(Context);
			base.Render (writer);
		}

	}
}
