using System;
using System.Web.UI.WebControls;   
using System.Web.UI;

namespace MetaSite.Components.Controls
{
	/// <summary>
	/// PertmissionSet
	/// </summary>
	public class PertmissionSet : WebControl,INamingContainer   
	{		
		RadioButtonList CheckList;

		public PertmissionSet()
		{
             CreateChildControls();
		}
		
		
		protected override void CreateChildControls()
		{
			this.Controls.Clear();
			this.ClearChildViewState();

			CheckList = new RadioButtonList();
			CheckList.RepeatDirection = RepeatDirection.Horizontal; 
 
			CheckList.Items.Add("");
			CheckList.Items.Add("ܾ");
			CheckList.Items.Add("δ");	
		
			if ( Allow)
				CheckList.Items[0].Selected = true;
			else
				CheckList.Items[1].Selected = true;

			
			this.Controls.Add( CheckList);		
		}		

		public bool Allow
		{
			get
			{
				object o = ViewState["Allow"];				
				return (o == null ? false : (bool)o);				
			}
			set
			{
				 ViewState["Allow"] = value;
				if ( value)
					CheckList.Items[0].Selected = true;
				else
					CheckList.Items[1].Selected = true;
			}
		}		

		public AccessControlEntry AccessControlEntry
		{
			get
			{
				if ( CheckList.Items[0].Selected )
					return AccessControlEntry.Allow; 
				else if (CheckList.Items[1].Selected )
					return AccessControlEntry.Deny;
				else
					return AccessControlEntry.NotSet; 
			}
			set
			{
				switch ( value)
				{
					case  AccessControlEntry.Allow:
						CheckList.Items[0].Selected = true;
						break;
					case AccessControlEntry.Deny:
						CheckList.Items[1].Selected = true;
						break;
					case AccessControlEntry.NotSet:
						CheckList.Items[2].Selected = true;
						break;
				}
			}
		}		
	}
}
