using System;
using Meta.Web;
using Meta.Web.Controls;
using Meta.Web.Security; 

namespace MetaSite.Components.Controls
{
	/// <summary>
	/// TopBar
	/// </summary>
	public class TopBar : Menubar 
	{
		ContextData context;

		public TopBar()
		{
            try
            {
                context = ContextData.Current;
                User user = context.User;               
                this.Items.Clear();
                this.Items.Add(CreateMenubarItem("ҳ", "~/default.aspx"));
                this.Items.Add(CreateMenubarItem(FunctionLabel.Homepage));
                this.Items.Add(CreateMenubarItem(FunctionLabel.Favorite));

                if (!context.Context.Request.IsAuthenticated)
                {
                    this.Items.Add(CreateMenubarItem("¼", "~/login.aspx"));
                    this.Items.Add(CreateMenubarItem("ע", "~/user/createuser.aspx"));
                }
                else
                {
                    AdminSettings.FileLocation = "~/admin.config";

                    if (AdminSettings.InAdminRoles())
                        this.Items.Add(CreateMenubarItem("", "~/admin"));
                    else                   
                        this.Items.Add(CreateMenubarItem("ʻ", "~/user/EditProfile.aspx"));                   

                    this.Items.Add(CreateMenubarItem("˳", "~/logout.aspx"));
                }
            }
            catch { }
		}


		public static MenubarItem CreateMenubarItem(string text,string url)
		{
			MenubarItem item = new MenubarItem();
			item.Text = text;
			item.NavigateUrl = url;  		
			return item;
		}

		public static MenubarItem CreateMenubarItem(FunctionLabel fun)
		{
			MenubarItem item = new MenubarItem();
			item.FunctionLabel = fun; 		
			item.Text = ""; 
			return item;
		}
	}
}
