using System;
using System.Configuration;
using System.Web;
using System.Web.Configuration;
using System.Web.UI.WebControls;   
using Meta.Web.Controls.Template;   
using Meta.Web.Security; 
using Meta.Web;


namespace MetaSite.Components.Controls.Views
{
	/// <summary>
	/// Admin
	/// </summary>
	public class Admin : BaseTemplateControl
	{
        Button btOk;
        DropDownList themeList;
        Button btSetname;
        TextBox txtName;
		protected override void AttachChildControls()
		{
			if ( !AdminSettings.InAdminRoles("Default"))
			{
				ForumPermission.RedirectOrExcpetion();			
			}

            btOk = FindControl("btOk") as Button;
            btOk.Click += new EventHandler(btOk_Click);
            themeList = FindControl("themeList") as DropDownList;
            btSetname = FindControl("btSetname") as Button;
            txtName = FindControl("txtName") as TextBox ;

            btSetname.Click += new EventHandler(btSetname_Click);

            if (!Page.IsPostBack)
            {
                string AppPath = HttpContext.Current.Request.PhysicalApplicationPath + @"\theme";
                string[] DirectoriesArray = System.IO.Directory.GetDirectories(AppPath, "*");

                foreach (string s in DirectoriesArray)
                {
                    themeList.Items.Add(s.Replace(AppPath+@"\", "")); 
                }

                string theme = Meta.Web.Configuration.Settings.Theme.ToLower().Replace("theme/", "");
                theme = theme.Replace("/", "");

                ListItem item = themeList.Items.FindByText(theme);

                if (item != null)
                {
                    themeList.SelectedIndex = themeList.Items.IndexOf(item);  
                }
                                 
                 txtName.Text = ConfigurationManager.AppSettings.Get("sitename");   
            } 
		}

        void btSetname_Click(object sender, EventArgs e)
        {
            Meta.Web.Configuration.Settings.SetAppValue("sitename", txtName.Text);  
        }

        void btOk_Click(object sender, EventArgs e)
        {           
            Meta.Web.Configuration.Settings.Theme = "theme/" + themeList.SelectedValue + "/";            
        }
	}
}
