using System;
using System.Data; 
using System.Web.UI.WebControls;   
using System.ComponentModel;
using Meta.Web.Controls.Template;   
using Meta.Web.Security; 
using Meta.Web;
using FreeTextBoxControls;

namespace MetaSite.Components.Controls.Views
{
	/// <summary>
	/// AdminPostEditer
	/// </summary>
	public class AdminPostEditer : BaseTemplateControl
	{
		FreeTextBox PostText;
		TextBox TitleText;
		Button btOk;
		CheckBox IsLock;

		TextBox txtUrl;
		CheckBox ckIndex;	
		ImageIndex index; 
		
		ContextData context = ContextData.Current ;

		User user;
		Post post;

		Forum forum;

		bool isEdit = false;
	
		public AdminPostEditer()
		{
			user = context.User;	

			int pid = -2;

			if ( (pid = context.GetIntFromQueryString("postid",-1)) > 0)
			{
				post = Posts.GetPost(pid);	
				isEdit = true;
			}
			else
			{
				forum = Forums.GetForum(context.GetIntFromQueryString("forumid",-1));
			}
		}
		protected override void AttachChildControls()
		{
			TitleText = (TextBox) FindControl("TitleText");
			PostText = (FreeTextBox) FindControl("PostText");		
			IsLock = (CheckBox) FindControl("IsLock");		
			btOk = (Button) FindControl("btOk");
			btOk.Click += new EventHandler(cmdEidt_Click);

			txtUrl = (TextBox) FindControl("txtUrl");
			ckIndex = (CheckBox) FindControl("ckIndex");				
			
			if (isEdit)
			{
				Permissions.AccessCheck(post.Forum,Permission.Edit,context.User,post);
				TitleText.Text = post.Subject;
				PostText.Text = post.Body;

				index = ImageIndexs.GetIndex(post.PostId);
  
				if ( index != null)
				{
					ckIndex.Checked = true;
					txtUrl.Text = index.ImageUrl;
				}
			}
			else
			{
				post = new Post(); 
				Permissions.AccessCheck(forum,Permission.Post,context.User,post);
			}

			if ( forum == null)
				forum = post.Forum; 

			ForumPermission fp = forum.ResolvePermission(context.User); 

			IsLock.Visible = ( fp.Administer && fp.Edit && post.PostLevel == 1); 

			Context.Items.Add(PageHead.key,"Ϣ");
		}

		private void cmdEidt_Click(object sender, EventArgs e)
		{
			Post addPost = new Post();
 
			if (isEdit)
			{			
				addPost = post;					
			}			
		
			addPost.User    = user;
			addPost.Subject = TitleText.Text;
			addPost.Body    = PostText.Text;  
			addPost.IsLocked = IsLock.Checked; 

			addPost = AddPost(addPost);

			if (isEdit)
			{
				if ( index != null)
				{
					index.ImageUrl = txtUrl.Text; 
					if ( ckIndex.Checked )
					{
						ImageIndexs.UpdateIndex(index); 
					}
					else
					{
						ImageIndexs.DeleteIndex(addPost.PostId); 
					}
				}
				else
				{
					if ( ckIndex.Checked )
					{
						CreateIndex(addPost);						
					}
				}						
			}
			else
			{
				if ( ckIndex.Checked )
				{
					CreateIndex(addPost);						
				}
			}

			if ( isEdit)
			{				
				Page.Response.Redirect(Globals.UrlBase + "/admin/forums/ModerateForum.aspx?forumid="+addPost.ForumId.ToString());
			}
			else			
			{
				Page.Response.Redirect(Globals.UrlBase + "/admin/forums/Moderates.aspx"); 
			}	
		}

		private void CreateIndex(Post p)
		{
			index = new ImageIndex();
			index.PostId = p.PostId;
			index.ImageUrl = txtUrl.Text;
			string sj = TitleText.Text.Replace("&nbsp;","");
			index.Subject = sj.Length >10 ? sj.Substring(0,10):sj; 			
			sj = PostText.Text.Length > 100? PostText.Text.Substring(0,100):post.Body;
			index.Comment = sj.Replace("&nbsp;","");
			index.PostDate = post.PostDate;
			ImageIndexs.CreateIndex(index); 
		}

		private Post AddPost (Post p) 
		{
			Post newPost = null;

			
			if ( !isEdit)
			{				
				p.ForumId = context.GetIntFromQueryString("forumid",-1); 		
				p.PostLevel = 1;
				p.TotalViews = 0;					
				p.SortOrder = 0;
				p.IsApproved = (!p.Forum.IsActive);  
				newPost = Posts.AddPost(p);
			}
			else			
			{
				Posts.UpdatePost(p);
				newPost = Posts.GetPost(p.PostId);
			}					

			return newPost;
		}	
		
	}
}
