using System;
using System.Collections.Specialized;
using System.Text;
using System.Web.UI.WebControls;  
using Meta.Web;
using Meta.Web.Security;
using Meta.Web.Controls;
using Meta.Web.Controls.Template;
using MetaSite.Components.Providers; 

namespace MetaSite.Components.Controls.Views
{
    public class ChildHeader : BaseTemplateControl
    {       
        ListMenu menu;       
        int parent = -1;
        int forumId = -1;

        protected override void AttachChildControls()
        {
            ContextData context = ContextData.Current;
            forumId = context.GetIntFromQueryString("forumid", -1);
            parent = context.GetIntFromQueryString("parent", -1);
            Forum forum = (forumId > -1)? Forums.GetForum(forumId):Forums.GetForum(parent);
            Context.Items.Add(PageHead.key, forum.Name);

            menu = FindControl("menu") as ListMenu;            

            if (forumId > -1)
            {                 
                if (forum.ParentId > -1 && ( forum = Forums.GetForum(forum.ParentId)).IsGroup)
                {
                    menu.ParentId = forum.ForumId;                   
                } else{
                    menu.Visible = false; 
                }               
            }          
        }
    }
}
