using System;
using System.Data; 
using System.Collections; 
using System.Web.UI.WebControls;   
using System.ComponentModel;
using Meta.Web.Controls.Template;   
using Meta.Web.Security; 
using Meta.Web;
using Meta.Web.Controls; 
using Meta.Web.Controls.MasterPages; 
using MetaSite.Components.Providers;


namespace MetaSite.Components.Controls.Views
{
	/// <summary>
	/// CommentView
	/// </summary>
	public class CommentView : BaseTemplateControl
	{		
		TemplateContainer subContainer;		
		int PostId;
		ContextData context;
		Post post;
		PostData hander;
		Literal comment;
		
		protected override void AttachChildControls()
		{
			context = ContextData.Current; 
			PostId = context.GetIntFromQueryString("PostId",-1);				
			post = Posts.GetPost(PostId,true);

			//ҳtitle
			Context.Items.Add(PageHead.key,post.Subject+"-"); 

			Permissions.AccessCheck(post.Forum,Permission.View,context.User,post);

			ForumPermission fp = post.Forum.ResolvePermission(context.User);	

			hander = (PostData) FindControl("RPost");
			comment = (Literal) FindControl("comment");
			comment.Text = "<HR width=\"100%\" SIZE=\"1\">";
			comment.Text += "<B>\""+post.Subject +"\"<B>";
			comment.Text += "<HR width=\"100%\" SIZE=\"1\">";

			if( post.IsLocked || !fp.Reply)
			{
				hander.Visible = false;	
				comment.Visible = false;
			}

			//navigation = (MapPath) FindControl("navigation");	
			//navigation.Nodes.Add("̳","default.aspx");			
			//navigation.Nodes.Add(post.Forum.Name,"showforum.aspx?forumid="+post.ForumId);
			//navigation.Nodes.Add(post.Subject,"");

			DataTable src = Posts.GetPosts(PostId);			

			subContainer = (TemplateContainer) FindControl("subContainer");			

			DataTable ps = src.Copy(); 

			ps.Rows[0].Delete();  

			subContainer.ListItems[0].DataSource = ps; 						

			subContainer.Header.Text = ""+(post.Topic.TotalPosts).ToString()+ "";

            ContentContainer Container = (ContentContainer)Page.FindControl("Container");
            Meta.Web.Controls.MasterPages.Content MapPathRegion = null;
            foreach (Meta.Web.Controls.MasterPages.Content c in Container.Items)
            {
                if (c.ID == "MapPathRegion")
                {
                    MapPathRegion = c;
                    break;
                }
            }

            if (MapPathRegion != null)
            {
                MapPath mapPath = (MapPath)MapPathRegion.FindControl("mapPath");
                mapPath.Nodes.Add(post.Subject, Globals.UrlBase + "/ShowOfficialPost.aspx?postid=" + post.PostId.ToString());
                mapPath.Nodes.Add("", "");
            }				
		}
	}
}
