using System;
using System.Web.UI.WebControls;   
using Meta.Web;
using Meta.Web.Security; 

namespace MetaSite.Components.Controls.Views
{
	/// <summary>
	/// DeletePost
	/// </summary>
	public class DeletePost : WebControl
	{
		ContextData context = ContextData.Current ;

		User user;
		Post post;

		public DeletePost()
		{
			user = context.User;	

			int pid = -2;

			if ( (pid = context.GetIntFromQueryString("postid",-1)) > 0)
			{
				post = Posts.GetPost(pid);

				Permissions.AccessCheck(post.Forum,Permission.Delete,user,post);
				
				Posts.DeletePost(pid); 
			}
            
			if ( post.Forum.ForumType == ForumType.Forum)  
		    	Context.Response.Redirect(Globals.UrlBase + "/forum/showforum.aspx?forumid="+post.ForumId.ToString()); 
			else
				Context.Response.Redirect(Globals.UrlBase + "/showlist.aspx?forumid="+post.ForumId.ToString()); 
		}
	}
}
