using System;
using System.Web;
using System.Web.UI.WebControls;   

namespace MetaSite.Components.Controls.Views
{
	/// <summary>
	/// Footer
	/// </summary>
	public class Footer : WebControl 
	{
		public string ResourceCode 
		{
			get
			{
				object o = ViewState["ResourceCode"]; 
				return o == null? string.Empty : (string)o;
			} 			
			set { ViewState["ResourceCode"] = value; }
		}

		protected override void RenderContents(System.Web.UI.HtmlTextWriter writer)
		{
			if ( ResourceCode == string.Empty)
				return;

			Resource r = Resources.GetResource( ResourceCode);

			writer.Write(r.Text);  

			base.RenderContents (writer);
		}

	}
}
