using System;
using System.Data;
using System.Web.UI;
using System.Web.UI.WebControls;
using Meta.Web;
using Meta.Web.Controls.Template;  

namespace MetaSite.Components.Controls.Views
{
	/// <summary>
	/// ForumAdmin
	/// </summary>
	public class ForumAdmin : BaseTemplateControl
	{
		TextBox TextName;
		TextBox TextDescription;
		DropDownList TypeList;
		RadioButtonList  ListActive;
		
		Button CommandUpdate;
		Button CommandDelete;
		ContextData context = ContextData.Current; 
		Forum forum;

		public ForumAdmin()
		{
			if ( !AdminSettings.InAdminRoles("ManageForums"))
			{
				ForumPermission.RedirectOrExcpetion();			
			}

            forum = Forums.GetForum(context.GetIntFromQueryString("forumid",-1));
			if (forum == null)
			{				
				context.Context.Response.End();     
			}
		}

		protected override void AttachChildControls()
		{
			TextName = (TextBox)FindControl( "TextName" );
			TextDescription = (TextBox)FindControl( "TextDescription" );
			TypeList = (DropDownList)FindControl( "TypeList" );
			ListActive = (RadioButtonList)FindControl( "ListActive" );
			
			CommandUpdate = (Button)FindControl( "CommandUpdate" );
			CommandDelete = (Button)FindControl( "CommandDelete" );		
			CommandUpdate.Command += new CommandEventHandler(CommandUpdate_Command); 
			CommandDelete.Command += new CommandEventHandler(CommandDelete_Command);

			TextName.Text = forum.Name;
			TextDescription.Text = forum.Description;
			TypeList.SelectedIndex = (int)forum.ForumType;
            if (forum.IsGroup || forum.ParentId > -1)
                TypeList.Enabled = false;
 
			if(forum.IsActive)
				ListActive.Items[0].Selected = true;
			else
				ListActive.Items[1].Selected = true;

			Context.Items.Add(PageHead.key,"");
 
		}

		private void CommandUpdate_Command(object sender, CommandEventArgs e)
		{
			forum.Name = TextName.Text;
			forum.Description = TextDescription.Text;
			forum.ForumType = (ForumType)TypeList.SelectedIndex;
			forum.IsActive = ListActive.Items[0].Selected ? true:false;
            Forums.UpdateForum(forum);
            string q = forum.ParentId == -1 ? "" : "?parent=" + forum.ParentId;
            context.Context.Response.Redirect(Globals.UrlBase + "/admin/forums/ManageForums.aspx"+q); 
		}

		private void CommandDelete_Command(object sender, CommandEventArgs e)
		{
            Forums.DeleteForum(forum);
            string q = forum.ParentId > -1 ? "" : "?parent=" + forum.ParentId;
			context.Context.Response.Redirect(Globals.UrlBase + "/admin/forums/ManageForums.aspx"+q); 
		}
	}
}
