using System;
using System.Data; 
using System.Collections;
using System.Collections.Specialized;
using System.Web.UI.WebControls;   
using System.ComponentModel;
using Meta.Web.Controls.Template;   
using Meta.Web.Security; 
using Meta.Web;
using MetaSite.Components.Providers;

namespace MetaSite.Components.Controls.Views
{
	/// <summary>
	/// ForumGroupView
	/// </summary>	
	public class ForumGroup : BaseTemplateControl
	{
        GridView ForumGrid;
        GridView GroupGrid;
        MapPath mappath;
        int parent = -1;

        protected override void AttachChildControls()
        {
            parent = ContextData.Current.GetIntFromQueryString("parent", -1);

            ForumGrid = FindControl("ForumGrid") as GridView;
            GroupGrid = FindControl("GroupGrid") as GridView;
            mappath = FindControl("mappath") as MapPath;

            mappath.Nodes.Clear();
            mappath.Nodes.Add("̳", "default.aspx");

            if (parent > -1)
            {
                Forum f = Forums.GetForum(parent);
                Context.Items.Add(PageHead.key, f.Name);

                NameValueCollection list = new NameValueCollection();

                list.Add(f.Name, "forum/default.aspx?parent=" + f.ForumId);

                while (f.ParentId > -1)
                {
                    f = Forums.GetForum(f.ParentId);
                    list.Add(f.Name, "forum/default.aspx?parent=" + f.ForumId);
                }

                for (int i = list.Keys.Count - 1; i > -1; i--)
                {
                    mappath.Nodes.Add(list.Keys[i], list[list.Keys[i]]);
                }                
            }
            else
            {               
                Context.Items.Add(PageHead.key, "̳");
            }
        }

        protected override void OnInit(EventArgs e)
        {            
            base.OnInit(e);           
            DataBind();
        }

        public override void DataBind()
        {
            base.DataBind();
          
            DataTable src = null; 
            if (parent == -1)
                src = Forums.GetForumGroup(ForumType.Forum, 1);
            else
                src = Forums.GetForumGroup(parent, 1);

            if (src.Rows.Count == 0)
                this.FindControl("groupDiv").Visible = false;
            else
            {
                GroupGrid.Columns.Clear();
                HyperLinkField gname = new HyperLinkField();
                gname.DataNavigateUrlFields = new string[] { "ForumId" };
                gname.DataNavigateUrlFormatString = "~/forum/default.aspx?parent={0}";
                //gname.Target = "_blank";
                gname.DataTextField = "Name";
                gname.ItemStyle.Width = 250;
                gname.HeaderText = "";
                GroupGrid.Columns.Add(gname);

                BoundField gDes = new BoundField();
                gDes.HeaderText = "";
                gDes.DataField = "Description";
                GroupGrid.Columns.Add(gDes);
                GroupGrid.DataSource = src;
                GroupGrid.DataBind();
            }

            ForumGrid.Columns.Clear();
            HyperLinkField name = new HyperLinkField();
            name.DataNavigateUrlFields = new string[] { "ForumId" };
            name.DataNavigateUrlFormatString = "~/forum/showforum.aspx?forumid={0}";
            //name.Target = "_blank";ýϺ
            name.DataTextField = "Name";
            name.ItemStyle.Width = 250; 
            name.HeaderText = "";

           
            ForumGrid.Columns.Add(name);

            BoundField Des = new BoundField();
            Des.HeaderText = "";
            Des.DataField = "Description";            
            ForumGrid.Columns.Add(Des);

            BoundField topic = new BoundField();
            topic.HeaderText = "";
            topic.DataField = "TotalTopics";
            topic.ItemStyle.HorizontalAlign = HorizontalAlign.Center;
            topic.ItemStyle.Width = 100; 
            ForumGrid.Columns.Add(topic);

            BoundField post = new BoundField();
            post.HeaderText = "";
            post.DataField = "TotalPosts";
            post.ItemStyle.HorizontalAlign = HorizontalAlign.Center;
            post.ItemStyle.Width = 100; 
            ForumGrid.Columns.Add(post);

            if ( parent == -1)            
                ForumGrid.DataSource = Forums.GetForumGroup( ForumType.Forum,0);
            else
                ForumGrid.DataSource = Forums.GetForumGroup(parent, 0);
          
            ForumGrid.DataBind();
        }       
	}
}
