using System;
using System.Data; 
using System.Web.UI.WebControls;   
using System.ComponentModel;

using Meta.Web;
using Meta.Web.Security; 
using Meta.Web.Controls; 
using Meta.Web.Controls.Template; 
using MetaSite.Components.Providers;

namespace MetaSite.Components.Controls.Views
{
	/// <summary>
	/// Header
	/// </summary>
	public class Header : BaseTemplateControl
	{
		Menubar menus;	
		//System.Web.UI.WebControls.Image Logo;
		ContextData context; 
		
		string selectmenu;
		
		protected override void AttachChildControls()
		{
			context = ContextData.Current; 

			menus = (Menubar) FindControl("menus");
            menus.MenuItemStyle.CssClass = "menuitem";  
		
			AdminSettings.FileLocation =  "~/SiteMap.config";

			ToolItemCollection tools = AdminSettings.GetTools();

			menus.Items.Clear();		

			DataTable t = Forums.GetForumGroup(ForumType.News,2);

            InitMenu(t, menus.Items);
			/*foreach ( DataRow dr in t.Rows )
			{
				Forum f = CommonDataProvider.FormatForum(dr);
				MenubarItem mb = new MenubarItem();
				mb.Text = f.Name;
				mb.ID = f.ForumId.ToString();					
				mb.NavigateUrl = "~/showlist.aspx?forumid=" + f.ForumId.ToString();	
				mb.Target = "";
				menus.Items.Add(mb);				
			}*/

			selectmenu = GetSelect(tools.ToolItems);
			AddItem(menus,tools.ToolItems);  
			AddForum(menus);
		}

        private void InitMenu(DataTable t,MenubarItemCollection ms)
        {
            foreach (DataRow dr in t.Rows)
            {
                Forum f = CommonDataProvider.FormatForum(dr);
                MenubarItem mb = new MenubarItem();
                mb.Text = f.Name;
                mb.ID = "menu_"+f.ForumId.ToString();                     
                ms.Add(mb);
                if (f.IsGroup)
                {
                    mb.NavigateUrl = "~/showgrouplist.aspx?parent=" + f.ForumId.ToString();
                    InitMenu(Forums.GetForumGroup(f.ForumId, 2), mb.ChildItems);
                }
                else
                    mb.NavigateUrl = "~/showlist.aspx?forumid=" + f.ForumId.ToString();
                 
            }
        }

		private string GetSelect(ToolItem[] tools)
		{
			string select = System.IO.Path.GetFileNameWithoutExtension(Page.Request.FilePath).ToLower();	

			foreach( ToolItem tool in tools )
			{
				if ( tool.Name.ToLower() == select)
				{
					return select;
				}

				if ( tool.HasSelects )
				{
					string[] ss = tool.Selects.Split(',');
  
					foreach(string s in ss)
					{
						if ( s.ToLower() == select)
							return tool.Name.ToLower(); 
					}
				}				
			}		

			return "default";
		}

		private void AddItem( Menubar bar,ToolItem[] tools )
		{
			foreach( ToolItem tool in tools )
			{
				bool show = true;

				if ( tool.HasRoles )
				{
					string[] rs = tool.Roles.Split(','); 
					foreach(string r in rs)
					{
						if( Roles.IsUserInRole(r))
							break;						
					}
					show = false;
				}

				if ( !show)
					continue;

				MenubarItem mb = new MenubarItem();
				mb.Text = tool.Text;
				mb.ID = tool.Name;						
				mb.NavigateUrl = tool.Href;	
				mb.Target = tool.Target;
				bar.Items.Add(mb);
			}				
		}

		private void AddForum(Menubar bar)
		{
			MenubarItem mb = new MenubarItem();
			mb.Text = "̳";
			mb.ID = "toolforum";				
			mb.NavigateUrl = "~/forum/default.aspx";	
			//mb.Target = "_blank";
			bar.Items.Add(mb);			
		}		
	}
}
