using System;
using Meta.Web;
using Meta.Web.Controls; 

namespace MetaSite.Components.Controls.Views
{
	/// <summary>
	/// HotPosts
	/// </summary>
	public class HotPosts : TemplateContainer
	{
        public string ListCss
        {
            get
            {
                object o = ViewState["ListCss"];
                return o == null ? string.Empty : (string)o;
            }
            set { ViewState["ListCss"] = value; }
        }

        public int ForumId
        {
            get
            {
                object o = ViewState["ForumId"];
                return o == null ? -1 : (int)o;
            }
            set { ViewState["ForumId"] = value; }
        }

		public int ForumType
		{
			get
			{
				object o = ViewState["ForumType"];
				return o==null? 0:(int)o;
			}
			set{ViewState["ForumType"] = value;}
		}

		protected override void Render(System.Web.UI.HtmlTextWriter writer)
		{			
			if ( ForumType == 0)
	    		this.Header.Text = "̳";	
			else
				this.Header.Text = "ȵ";

            SimpleList sl = new SimpleList();

            if (ListCss != string.Empty)
                sl.CssClass = ListCss;
           

            sl.Navigates.Add("<FONT face=\"\">[", "");

            if (ForumType == 0)           
                sl.Navigates.Add("{4}", Globals.UrlBase + "/forum/showforum.aspx?forumid={1}");           
            else          
                sl.Navigates.Add("{4}", Globals.UrlBase + "/showlist.aspx?forumid={1}");

            sl.Navigates.Add("]</FONT>", "");	
         

			if ( ForumType == 0)
                sl.Navigates.Add("{3}", Globals.UrlBase + "/forum/showpost.aspx?postid={2}");		
			else
                sl.Navigates.Add("{3}", Globals.UrlBase + "/ShowOfficialPost.aspx?postid={2}");			

			
			if ( ForumType == 0)						
                sl.Navigates.Add("{0}", "");  
			

            if ( ForumId == -1)
		    	sl.DataSource = Topics.GetHotTopics((ForumType)ForumType,sl.PageSize);	
	        else
                sl.DataSource = Topics.GetHotTopics(ForumId, sl.PageSize);	

			sl.PageSize = 10;
			sl.MaxLenght = 35;
			this.ListItems.Add(sl);
			base.Render (writer);
		}
	}
}
