using System;
using System.Collections.Generic;
using System.Text;
using System.Data;

using Meta.Web;
using Meta.Web.Controls;
using MetaSite.Components.Providers;     

namespace MetaSite.Components.Controls.Views
{
    public class HotPostsTab : TabPanel 
    {
        public string ListCss
        {
            get
            {
                object o = ViewState["ListCss"];
                return o == null ? string.Empty : (string)o;
            }
            set { ViewState["ListCss"] = value; }
        }

        public ForumType Forumtype
        {
            get
            {
                object o = ViewState["Forumtype"];
                return o == null ? ForumType.Forum : (ForumType)o;
            }
            set { ViewState["Forumtype"] = value; }
        }
        protected override void Render(System.Web.UI.HtmlTextWriter writer)
        {
            DataTable t = Forums.GetForumGroup(Forumtype,2);
            int count = 0;
            foreach (DataRow dr in t.Rows)
            {
                Forum f = CommonDataProvider.FormatForum(dr);
                TabItem tm = new TabItem();
                tm.Text = f.Name;
                if (Forumtype == ForumType.Forum)
                {
                    if (f.IsGroup)
                        tm.NavigateUrl = Globals.UrlBase + "/forum/default.aspx?parent=" + f.ForumId.ToString();
                    else
                        tm.NavigateUrl = Globals.UrlBase + "/forum/showforum.aspx?forumid=" + f.ForumId.ToString();
                }
                else
                {
                    if (f.IsGroup)
                        tm.NavigateUrl = Globals.UrlBase + "/showgrouplist.aspx?parent=" + f.ForumId.ToString();
                    else
                        tm.NavigateUrl = Globals.UrlBase + "/showlist.aspx?forumid=" + f.ForumId.ToString();
                }

                tm.PageControl = GetList(f.ForumId);
                this.Items.Add(tm);
                count++;
                if (count > 6)
                    break;
            }            
            
            base.Render(writer);
        }

        private ListView GetList(int forumId)
        {
            SimpleList sl = new  SimpleList();
            if (ListCss != string.Empty)
                sl.CssClass = ListCss;          
           
            sl.Navigates.Add("<FONT face = \"\">", "");
          
            if (Forumtype == ForumType.Forum)
            {
                sl.Navigates.Add("{3}", Globals.UrlBase + "/forum/showpost.aspx?postid={2}");
                sl.Navigates.Add("({0})", "");
            }
            else
                sl.Navigates.Add("{3}", Globals.UrlBase + "/ShowOfficialPost.aspx?postid={2}");

            sl.Navigates.Add("</FONT>", "");
            sl.PageSize = 10;
            sl.MaxLenght = 20;

            sl.DataSource = Topics.GetHotTopics(forumId,sl.PageSize);

            return sl;
        }
    }
}
