using System;
using System.Data; 
using Meta.Web;
using Meta.Web.Controls; 
using Meta.Web.Controls.MasterPages; 
using MetaSite.Components.Providers;

namespace MetaSite.Components.Controls.Views
{
	/// <summary>
	/// IndexList
	/// </summary>
	public class IndexList : TemplateContainer
	{
		public string TitleCss
		{
			get
			{
				object o = ViewState["TitleCss"];
				return o==null? string.Empty :(string)o;
			}
			set{ViewState["TitleCss"] = value;}
		}

		public string TextCss
		{
			get
			{
				object o = ViewState["TextCss"];
				return o==null? string.Empty :(string)o;
			}
			set{ViewState["TextCss"] = value;}
		}
	
		protected override void Render(System.Web.UI.HtmlTextWriter writer)
		{			
			this.Header.Text = "ƷƼ";	

			SpecialList sl = new SpecialList();			

			sl.ImageUrlFormat = Globals.UrlBase+"/Resources/images/Index/{1}";
			sl.TitleNavigates.Add("{2}",Globals.UrlBase + "/ShowOfficialPost.aspx?postid={0}"); 
			sl.TextNavigates.Add("{3}(","");  
			sl.TextNavigates.Add("鿴ȫ",Globals.UrlBase + "/ShowOfficialPost.aspx?postid={0}"); 
			sl.TextNavigates.Add(")",""); 
			
			DataTable t = ImageIndexs.GetIndexs();		

			if ( t.Rows.Count == 0 )
				return;

			sl.DataSource = t;	
		
			sl.TitleStyle.CssClass =  TitleCss;
			sl.TextStyle.CssClass = TextCss;

            sl.MaxLenght = 30;
			sl.PageSize = 10;			
			
			this.ListItems.Add(sl);  
			base.Render (writer);				
		}
	}
}
