using System;
using System.Web.UI.WebControls;   
using Meta.Web;
using Meta.Web.Configuration; 

namespace MetaSite.Components.Controls.Views
{
	/// <summary>
	/// LinkImage
	/// </summary>
	public class LinkImage : Image
	{
		public string NavigateUrl 
		{
			get
			{
				object o = ViewState["NavigateUrl"]; 
				return o == null? string.Empty : (string)o;
			} 			
			set { ViewState["NavigateUrl"] = value; }
		}

		protected override void Render(System.Web.UI.HtmlTextWriter writer)
		{
			if ( NavigateUrl != string.Empty)
			{
				writer.Write("<a href = " + this.ResolveUrl(Urls.Instance()[NavigateUrl]) + " Target = '_blank'>");   
			}

			base.Render (writer);

			if ( NavigateUrl != string.Empty)
			{
				writer.Write("</a>");   
			}
		}
	}
}
