using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using Meta.Web;
using Meta.Web.Controls;
using MetaSite.Components.Providers;

namespace MetaSite.Components.Controls.Views
{
    public class ListMenu : Menubar 
    {
        int parent = -1;       

        public int ParentId
        {
            get { return parent; }
            set { parent = value; } 
        }

        private void InitMenu(DataTable t, MenubarItemCollection ms)
        {
            foreach (DataRow dr in t.Rows)
            {
                Forum f = CommonDataProvider.FormatForum(dr);
                MenubarItem mb = new MenubarItem();
                mb.Text = f.Name;
                mb.ID = "menu_" + f.ForumId.ToString();                
                ms.Add(mb);
                if (f.IsGroup)
                {
                    mb.NavigateUrl = "~/showgrouplist.aspx?parent=" + f.ForumId.ToString();
                    InitMenu(Forums.GetForumGroup(f.ForumId, 2), mb.ChildItems);                    
                }
                else
                    mb.NavigateUrl = "~/showlist.aspx?forumid=" + f.ForumId.ToString();

            }
        }

        protected override void Render(System.Web.UI.HtmlTextWriter writer)
        {
            if (parent == -1) parent = ContextData.Current.GetIntFromQueryString("parent", -1);
            DataTable t = Forums.GetForumGroup(ParentId, 2);
            MenubarItem m = new MenubarItem();
            Forum f = Forums.GetForum(parent);
            m.Text = f.Name + "ҳ";
            m.ID = "default_" + f.ForumId.ToString();
            m.NavigateUrl = "~/showgrouplist.aspx?parent=" + parent;
            this.Items.Add(m);
            InitMenu(t, this.Items);

            base.Render(writer);
        }
    }
}
