using System;
using System.ComponentModel;
using Meta.Web;
using Meta.Web.Security;  

namespace MetaSite.Components.Controls.Views
{
	/// <summary>
	/// Login
	/// </summary>
	//[Designer(typeof(Meta.Web.Controls.Design.DefaultDesginer)),]
	public class Login : TemplateContainer
	{
		User user ;
		ContextData context;

		public string IsLoginSink
		{
			get
			{
				object o = ViewState["IsLoginSink"];
				return o==null? "":(string)o;
			}
			set
			{
				ViewState["IsLoginSink"] = value;
				if (context.Context.Request.IsAuthenticated )
					this.SkinFileUrl = IsLoginSink;
			}
		}

		public Login()
		{	
			context = ContextData.Current; 
			user = ContextData.Current.User;	
			if (!context.Context.Request.IsAuthenticated )
			{
				LoginData dler =  new LoginData();
				this.DataHandler = dler; 
			}
			else
			{
                this.DataHandler = new LoginNavigation(); 
			}
			
			this.Header.Text ="Ա¼";				
		}

		public bool LoginPage
		{
			get
			{
				object o = ViewState["LoginPage"];
				return o == null? true:(bool)o;
			}

			set
			{
				ViewState["LoginPage"] = value;

				if ( value)
					Context.Items.Add(PageHead.key,"¼");
			}
		}
	}		
}
