using System;
using System.Data; 
using System.Web.UI.WebControls;   
using System.Web.Security;
using System.ComponentModel;
using Meta.Web.Controls.Template;   
using Meta.Web.Security; 
using Meta.Web;

namespace MetaSite.Components.Controls.Views
{
	/// <summary>
	/// Login
	/// </summary>
	[ToolboxItem(false),]
	public class LoginData : BaseTemplateControl
	{
		TextBox     UserId;
		TextBox     Password;		
		CustomValidator   loginValidator;		

		protected override void AttachChildControls()
		{			
			UserId = (TextBox) FindControl("UserId");			
			Password = (TextBox) FindControl("Password");				

            loginValidator = (CustomValidator) FindControl("loginValidator");
			loginValidator.ServerValidate += new ServerValidateEventHandler(ServerValidate);			

			//ҳtitle			
		}	
	
		private void ServerValidate(object source, ServerValidateEventArgs args)
		{
			if ( !(args.IsValid = Users.ValidateUser( UserId.Text,Password.Text)))
			{
				loginValidator.ErrorMessage = "¼Ϣ";
			}
			else
			{
				ContextData c = ContextData.Current;
			
				FormsAuthentication.SetAuthCookie(UserId.Text, false);
				
				Page.Response.Redirect(Globals.UrlBase);  
			}
		}
	}
}
