using System;
using System.Data; 
using System.Web.UI.WebControls;   
using System.Web.Security;
using System.ComponentModel;
using Meta.Web.Controls;
using Meta.Web.Controls.Template;   
using Meta.Web.Security; 
using Meta.Web;

namespace MetaSite.Components.Controls.Views
{
	/// <summary>
	/// LoginNavigation
	/// </summary>
	public class LoginNavigation : BaseTemplateControl
	{
		Menubar Leftbar;
		Menubar Rightbar;
		ContextData context;
		Literal Userhi;    
		
		protected override void AttachChildControls()
		{
			Leftbar = (Menubar) FindControl("Leftbar");
			Rightbar = (Menubar) FindControl("Rightbar");
			Userhi = (Literal) FindControl("Userhi");
			
			context = ContextData.Current; 
			User user = context.User;	

			Userhi.Text = "<FONT face='' color='red'>"+
					user.NickName+",,Ѿɹ¼!</FONT>";			
			
		
			Leftbar.Items.Add( CreateMenubarItem("ʻ","~/user/EditProfile.aspx",true));	
			Rightbar.Items.Add( CreateMenubarItem("","~/admin/security/password.aspx?userid="+user.UserId,true));		
			
			AdminSettings.FileLocation =  "~/admin.config";

			bool left = false;

			if ( AdminSettings.InAdminRoles())
			{				
				Leftbar.Items.Add( CreateMenubarItem("","~/admin/default.aspx",true));
				if ( AdminSettings.InAdminRoles("Moderates"))
				{
					Rightbar.Items.Add( CreateMenubarItem("","~/admin/forums/Moderates.aspx",true));		
					left = true;
				}
			}

			if (left)
		    	Leftbar.Items.Add( CreateMenubarItem("ע¼","~/logout.aspx",false));
			else
				Rightbar.Items.Add( CreateMenubarItem("ע¼","~/logout.aspx",false));
		}

		

		public static MenubarItem CreateMenubarItem(string text,string url, bool terget)
		{
			MenubarItem item = new MenubarItem();
			item.Text = text;
			item.NavigateUrl = url;  
			if ( terget)
				item.Target = "_blank";
		
			return item;
		}
	}
}
