using System;
using System.Data;
using System.Web.UI;
using System.Web.UI.WebControls;
using Meta.Web;
using Meta.Web.Controls.Template;  

namespace MetaSite.Components.Controls.Views
{
	/// <summary>
	/// ManageForums
	/// </summary>
	public class ManageForums : BaseTemplateControl
	{
		Repeater ForumRepeater;
        int parentId = -1;

		protected override void OnLoad(EventArgs e)
		{
			if ( !AdminSettings.InAdminRoles("ManageForums"))
			{
				ForumPermission.RedirectOrExcpetion();			
			}
 
			if ( !Page.IsPostBack ) 
			{
				DataBind();
			}
			base.OnLoad( e );
		}

		protected override void AttachChildControls()
		{
			ForumRepeater = (Repeater)FindControl( "ForumRepeater" );
			ForumRepeater.ItemCommand += new RepeaterCommandEventHandler(ForumRepeater_ItemCommand);
			ForumRepeater.ItemCreated += new RepeaterItemEventHandler(ForumRepeater_ItemCreated);
			Context.Items.Add(PageHead.key,"");
            parentId = ContextData.Current.GetIntFromQueryString("parent", -1);   
		}

		public override void DataBind()
		{
			base.DataBind ();
			DataBindForums();
		}

		protected void DataBindForums() 
		{
            ForumRepeater.DataSource = Forums.GetForumGroup(parentId,2); 
			ForumRepeater.DataBind();
		}
 
		protected virtual void MoveForumUp( int forumId ) 
		{
			Forums.ChangeForumSortOrder(forumId, true);			
			DataBindForums();
		}

		protected virtual void MoveForumDown( int forumId ) 
		{
			Forums.ChangeForumSortOrder(forumId, false);			
			DataBindForums();
		}

		private void ForumRepeater_ItemCommand(object source, RepeaterCommandEventArgs e)
		{
			switch( e.CommandName ) 
			{
				case "MoveUp":
					MoveForumUp( Convert.ToInt32( e.CommandArgument ) );
					break;
				case "MoveDown":
					MoveForumDown( Convert.ToInt32( e.CommandArgument ) );
					break;
				case "CreateForum":
					Control newforumButton = (Control)e.CommandSource;
					TextBox ForumName = newforumButton.NamingContainer.FindControl( "ForumName" ) as TextBox;	
					DropDownList TypeList = newforumButton.NamingContainer.FindControl( "TypeList" ) as DropDownList;	
                    CheckBox isGroup = newforumButton.NamingContainer.FindControl( "isGroup" ) as CheckBox;
                    CreateForum(ForumName.Text, (ForumType)TypeList.SelectedIndex, isGroup.Checked );
					break;
			}
		}

		private void ForumRepeater_ItemCreated(object sender, RepeaterItemEventArgs e)
		{
			if ( e.Item.ItemType == ListItemType.Item || e.Item.ItemType == ListItemType.AlternatingItem ) 
			{			
				HyperLink ForumAdminLink = (HyperLink)e.Item.FindControl( "ForumAdminLink" );
				ForumAdminLink.DataBinding += new EventHandler(ForumAdminLink_DataBinding);

                HyperLink subFormsLink = (HyperLink)e.Item.FindControl("subFormsLink");
                subFormsLink.DataBinding += new EventHandler(subFormsLink_DataBinding);

				Literal ForumDescription = (Literal)e.Item.FindControl( "ForumDescription") ;
				ForumDescription.DataBinding += new EventHandler(ForumDescription_DataBinding);	
			
				ImageButton MoveUp = (ImageButton)e.Item.FindControl( "MoveUp" );
				MoveUp.DataBinding += new EventHandler(MoveUp_DataBinding);
			
				ImageButton MoveDown = (ImageButton)e.Item.FindControl( "MoveDown" );
				MoveDown.DataBinding += new EventHandler(MoveDown_DataBinding);					
			}
			else if ( e.Item.ItemType == ListItemType.Header ) 
			{
				Button CreateForum = (Button)e.Item.FindControl( "CreateForum" );
                     
                if (parentId > -1){
                    DropDownList TypeList = e.Item.FindControl("TypeList") as DropDownList;
                    TypeList.Enabled = false;
                    TypeList.SelectedIndex = (int)Forums.GetForum(parentId).ForumType;  
                }

				CreateForum.DataBinding += new EventHandler(CreateForum_DataBinding);               
			}
		}     
		private void ForumAdminLink_DataBinding(object sender, EventArgs e)
		{
			HyperLink ForumAdminLink = (HyperLink)sender;
			RepeaterItem container = (RepeaterItem)ForumAdminLink.NamingContainer;
			ForumAdminLink.Text = Convert.ToString( DataBinder.Eval( container.DataItem, "Name" ) );
			ForumAdminLink.NavigateUrl = Globals.UrlBase + "/admin/forums/forumadmin.aspx?forumid=" + Convert.ToInt32(DataBinder.Eval( container.DataItem, "Forumid" ));
		}

        private void subFormsLink_DataBinding(object sender, EventArgs e)
        {
            HyperLink subFormsLink = (HyperLink)sender;
            RepeaterItem container = (RepeaterItem)subFormsLink.NamingContainer;
            if ((bool)DataBinder.Eval(container.DataItem, "IsGroup"))
            {
                subFormsLink.Text = "鿴Ӱ";
                subFormsLink.NavigateUrl = "~/admin/forums/ManageForums.aspx?parent=" + Convert.ToInt32(DataBinder.Eval(container.DataItem, "Forumid"));
            }
        }

		private void MoveUp_DataBinding(object sender, EventArgs e)
		{
			ImageButton MoveUp = (ImageButton)sender;
			RepeaterItem container = (RepeaterItem)MoveUp.NamingContainer;
			MoveUp.CommandName = "MoveUp";
			MoveUp.CommandArgument = Convert.ToString( DataBinder.Eval( container.DataItem, "ForumId" ) );
		}

		private void MoveDown_DataBinding(object sender, EventArgs e)
		{
			ImageButton MoveDown = (ImageButton)sender;
			RepeaterItem container = (RepeaterItem)MoveDown.NamingContainer;
			MoveDown.CommandName = "MoveDown";
			MoveDown.CommandArgument = Convert.ToString( DataBinder.Eval( container.DataItem, "ForumId" ) );
		}
	
		private void ForumDescription_DataBinding(object sender, EventArgs e)
		{
			Literal ForumDescription = (Literal)sender;
			RepeaterItem container = (RepeaterItem)ForumDescription.NamingContainer;
			string des = Convert.ToString( DataBinder.Eval( container.DataItem, "Description" ) );
			if(des != null)
				ForumDescription.Text = Context.Server.HtmlEncode(des);
		}

		private void CreateForum(string name,ForumType type,bool isGroup)
		{
            Forums.CreateForum(name, type, parentId, isGroup); 
            DataBindForums();
		}	

		private void CreateForum_DataBinding(object sender, EventArgs e)
		{
			Button CreateForum = (Button)sender;
			CreateForum.CommandName = "CreateForum";			
		}
	}
}
