using System;
using System.Data;
using System.Web.UI;
using System.Web.UI.WebControls;
using Meta.Web;
using Meta.Web.Controls; 
using Meta.Web.Controls.Template; 

namespace MetaSite.Components.Controls.Views
{
	/// <summary>
	/// ManageLink
	/// </summary>
	public class ManageLink : BaseTemplateControl
	{
		Literal Info;   
		DataGrid ModerateData; 

		TextBox txtTitle;
		TextBox txtUrl;
		Button btOk;
		
		protected override void AttachChildControls()
		{
			txtTitle = FindControl("txtTitle") as TextBox;
			txtUrl = FindControl("txtUrl") as TextBox;
			btOk = FindControl("btOk") as Button;

			btOk.Click += new EventHandler(btOk_Click);

			Info = FindControl("Info") as Literal;

			Info.Text = "<b>վ</B>";

			ModerateData = FindControl("ModerateData") as DataGrid;			
			ModerateData.ItemCommand += new DataGridCommandEventHandler(ModerateData_ItemCommand);  		
			
			if ( !AdminSettings.InAdminRoles("ManageLinks"))
			{
				ForumPermission.RedirectOrExcpetion();			
			}

			Context.Items.Add(PageHead.key,"ӹ");
		}

		protected override void OnInit(EventArgs e)
		{
			if ( !AdminSettings.InAdminRoles("ManageLinks"))
			{
				ForumPermission.RedirectOrExcpetion();			
			}
			base.OnInit (e);
			DataBind();
		}


		public override void DataBind()
		{
			base.DataBind ();

			ModerateData.Columns.Clear();

			HyperLinkColumn Name = new HyperLinkColumn();
			Name.DataNavigateUrlField = "url";
			Name.Target = "_blank";
			Name.DataTextField = "Title";
			Name.HeaderText = "ǩ";
			ModerateData.Columns.Add(Name); 				
		

			HyperLinkColumn url = new HyperLinkColumn();
			url.DataNavigateUrlField = "url";
			url.Target = "_blank";
			url.DataTextField = "url";
			url.HeaderText = "ַ";
			ModerateData.Columns.Add(url); 		

			ButtonColumn Up = new ButtonColumn();				
			Up.CommandName = "Up";
			Up.Text = "";	
			Up.ItemStyle.HorizontalAlign = HorizontalAlign.Center; 			
			ModerateData.Columns.Add(Up);

			ButtonColumn Down = new ButtonColumn();				
			Down.CommandName = "Down";
			Down.Text = "";	
			Down.ItemStyle.HorizontalAlign = HorizontalAlign.Center; 
			ModerateData.Columns.Add(Down);

			ButtonColumn Delete = new ButtonColumn();				
			Delete.CommandName = "Delete";
			Delete.Text = "ɾ";	
			Delete.ItemStyle.HorizontalAlign = HorizontalAlign.Center; 
			ModerateData.Columns.Add(Delete);			

			ModerateData.DataSource = Links.GetLinks(); 
			ModerateData.DataBind(); 
		}
	
		private void ModerateData_ItemCommand(object source, DataGridCommandEventArgs e)
		{
			DataTable dt = (DataTable)ModerateData.DataSource; 
			int linkId = int.Parse(dt.Rows[e.Item.DataSetIndex]["linkId"].ToString());

			switch(e.CommandName)
			{
				case "Up":					
					Links.ChangeLinkSortOrder(linkId,true); 
					DataBind();
					break;
				case "Down":
					Links.ChangeLinkSortOrder(linkId,false); 
					DataBind();
					break;
				case"Delete":
					Links.DeleteLink(linkId); 
					DataBind();
					break;
			}
		}

		private void btOk_Click(object sender, EventArgs e)
		{
            Links.AddLink(txtTitle.Text,txtUrl.Text);
			txtTitle.Text = "";
			txtUrl.Text = "";    
			DataBind();
		}
	}
}
