using System;
using System.Data;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Drawing;
using Meta.Web;
using Meta.Web.Security; 
using Meta.Web.Controls.Template;  
using MetaSite.Components.Providers; 

namespace MetaSite.Components.Controls.Views
{
	/// <summary>
	/// ManagePermissions
	/// </summary>
	public class ManagePermissions : BaseTemplateControl
	{
		Repeater PerRepeater;	
		DropDownList ForumList;	

		protected override void OnLoad(EventArgs e)
		{
			if ( !AdminSettings.InAdminRoles("ManagePermissions"))
			{
				ForumPermission.RedirectOrExcpetion();			
			}

			if ( !Page.IsPostBack ) 
			{
				DataBind();
			}
			base.OnLoad( e );			
		}

		protected override void AttachChildControls()
		{
			PerRepeater = (Repeater)FindControl( "PerRepeater" );
			PerRepeater.ItemCommand += new RepeaterCommandEventHandler(PerRepeater_ItemCommand);
			PerRepeater.ItemCreated += new RepeaterItemEventHandler(PerRepeater_ItemCreated);
			ForumList = (DropDownList)FindControl( "ForumList");
			ForumList.SelectedIndexChanged += new EventHandler(ForumList_SelectedIndexChanged);
			ForumList.AutoPostBack = true;

			if( !Page.IsPostBack)
			{
				DataTable tb = Forums.GetForumGroup();
				ForumList.DataSource = tb;
				ForumList.DataTextField = "name";
				ForumList.DataValueField = "forumid";
				ForumList.DataBind();  
				int forumid = 0;		
				if ( (forumid = ContextData.Current.GetIntFromQueryString("forumid",-1)) > 0)
				{
					for (int i = 0; i< ForumList.Items.Count;i++)
					{
						if ( ForumList.Items[i].Value == forumid.ToString())
						{
                            ForumList.SelectedIndex = i;
							break;
						}
					}					
				}
			}
			
			Context.Items.Add(PageHead.key,"Ȩ");
		
		}

		public override void DataBind()
		{			
			base.DataBind ();
			DataBindPer();
		}

		protected void DataBindPer() 
		{
			PerRepeater.DataSource = Permissions.GetPermissions(int.Parse(ForumList.SelectedValue)); 
			PerRepeater.DataBind();
		}

		private void PerRepeater_ItemCommand(object source, RepeaterCommandEventArgs e)
		{
			Button sender = e.CommandSource as Button; 
			switch( e.CommandName ) 
			{				
				case "Add":
					DropDownList RoleList = (DropDownList)sender.NamingContainer.FindControl("RoleList");				
					AddPermission(int.Parse(RoleList.SelectedValue));
					break;
				case "Del":						
					DelPermission( int.Parse(sender.CommandArgument)); 
					break;
			}
		}
		protected void SetImage(bool tf, Control c)
		{
			if(c == null || c.GetType() != typeof(System.Web.UI.WebControls.Image))
				return;

			System.Web.UI.WebControls.Image img = (System.Web.UI.WebControls.Image)c;

			if ( tf)
				img.ImageUrl = this.ResolveUrl("~/"+ Meta.Web.Configuration.Settings.Theme + "images/checkmark.gif");
			else
                img.ImageUrl = this.ResolveUrl("~/" + Meta.Web.Configuration.Settings.Theme + "images/crossmark.gif");
		}

		protected  void SetPermissions(RepeaterItem item)
		{
			ForumPermission fp = item.DataItem as ForumPermission;
			if ( fp == null)
				return;
			SetImage(fp.View,item.FindControl("ImgView"));
			SetImage(fp.Read,item.FindControl("ImgRead"));
			SetImage(fp.Post,item.FindControl("ImgPost"));
			SetImage(fp.Reply,item.FindControl("ImgReply"));
			SetImage(fp.Edit,item.FindControl("ImgEdit"));
			SetImage(fp.Delete,item.FindControl("ImgDel"));			
			SetImage(fp.Administer,item.FindControl("ImgAdmin"));			
		}


		private void PerRepeater_ItemCreated(object sender, RepeaterItemEventArgs e)
		{
			if ( e.Item.ItemType == ListItemType.Item || e.Item.ItemType == ListItemType.AlternatingItem ) 
			{			
				HyperLink LinkRole = (HyperLink)e.Item.FindControl( "LinkRole" );
				LinkRole.DataBinding += new EventHandler(LinkRole_DataBinding);

				Button CmdDelete = (Button)e.Item.FindControl( "CmdDelete" );
				CmdDelete.DataBinding += new EventHandler(CmdDelete_DataBinding);

				SetPermissions(e.Item);				
			}
			else if ( e.Item.ItemType == ListItemType.Header ) 
			{
				Button CmdAdd = (Button)e.Item.FindControl( "CmdAdd" );
				CmdAdd.DataBinding += new EventHandler(CmdAdd_DataBinding);
				DropDownList RoleList = e.Item.FindControl( "RoleList") as DropDownList;
				
				//RoleList.DataSource = Roles.GetAllRoles(); 
				RoleList.DataSource = new RolesProvider().GetRoles();
				RoleList.DataTextField = "rolename";
				RoleList.DataValueField = "roleId";
							
			}
		}

		private void LinkRole_DataBinding(object sender, EventArgs e)
		{
			HyperLink LinkRole = (HyperLink)sender;
			RepeaterItem container = (RepeaterItem)LinkRole.NamingContainer;
			LinkRole.Text = Convert.ToString( DataBinder.Eval( container.DataItem, "Name" ) );
			LinkRole.NavigateUrl = Globals.UrlBase + "/admin/forums/PermissionAdmin.aspx?"+
                              "forumid=" + ForumList.SelectedValue +"&"+
				"roleid=" + Convert.ToInt32(DataBinder.Eval( container.DataItem, "roleid" ));
		}	

		private void CmdAdd_DataBinding(object sender, EventArgs e)
		{
			Button CmdAdd = (Button)sender;
			CmdAdd.CommandName = "Add";			
		}

		private void CmdDelete_DataBinding(object sender, EventArgs e)
		{
			Button CmdDelete = (Button)sender;
			CmdDelete.CommandName = "Del";			
		}

		private void ForumList_SelectedIndexChanged(object sender, EventArgs e)
		{
            DataBindPer() ;
		}

		private void AddPermission(int roleId)
		{
			ForumPermission fp = new ForumPermission();
			fp.RoleId = roleId;
			fp.ForumId = int.Parse(ForumList.SelectedValue);  
			Permissions.AddPermission(fp); 

			Page.Response.Redirect(Globals.UrlBase + "/admin/forums/PermissionAdmin.aspx?"+
                              "forumid=" + fp.ForumId +"&roleid=" + roleId );  
		}

		private void DelPermission(int roleId)
		{
			ForumPermission fp = new ForumPermission();
			fp.RoleId = roleId;
			fp.ForumId = int.Parse(ForumList.SelectedValue);  
			Permissions.RemovePermission(fp); 
		}
	}
}
