using System;
using System.Data;
using System.Web.UI;
using System.Web.UI.WebControls;
using Meta.Web;
using Meta.Web.Controls; 
using Meta.Web.Controls.Template; 
using FreeTextBoxControls;

namespace MetaSite.Components.Controls.Views
{
	/// <summary>
	/// ManageResource
	/// </summary>
	public class ManageResource : BaseTemplateControl
	{				
		Button btAdd;
		Repeater RepeaterList;
        Pagination pager;

		protected override void AttachChildControls()
		{		
			btAdd = FindControl("btAdd") as Button;	
			btAdd.Click += new EventHandler(btAdd_Click);

            RepeaterList = FindControl("RepeaterList") as Repeater;	
			RepeaterList.ItemCreated += new RepeaterItemEventHandler(RepeaterList_ItemCreated);
			RepeaterList.ItemCommand += new RepeaterCommandEventHandler(RepeaterList_ItemCommand);
            pager = FindControl("pager") as Pagination;	
			
			Context.Items.Add(PageHead.key,"");

			Literal info = FindControl("Info") as Literal;
			info.Text = "<b></b>";

			if ( !AdminSettings.InAdminRoles("ManageResources"))
			{
				ForumPermission.RedirectOrExcpetion();			
			}

			if ( !Page.IsPostBack)
			{				
				RepeaterDataBind();
			}		
		}

		protected override void OnInit(EventArgs e)
		{
			if ( !AdminSettings.InAdminRoles("ManageResources"))
			{
				ForumPermission.RedirectOrExcpetion();			
			}
			base.OnInit (e);			
		}
	

		private void RepeaterDataBind()
		{
            int c = 0;
            DataTable t = Resources.GetResources(ref c, pager.PageSize, pager.PageIndex);            
            pager.TotalData = c;
            RepeaterList.DataSource = t;           
			RepeaterList.DataBind();
		}		

		private void btAdd_Click(object sender, EventArgs e)
		{
            Page.Response.Redirect( Globals.UrlBase + "/admin/resources/resourceadmin.aspx");			
		}

		private void RepeaterList_ItemCreated(object sender, RepeaterItemEventArgs e)
		{
			HyperLink EditLink = (HyperLink)e.Item.FindControl( "EditLink" );
			EditLink.DataBinding += new EventHandler(EditLink_DataBinding);

			LinkButton DelLink = (LinkButton)e.Item.FindControl( "DelLink" );
			DelLink.DataBinding += new EventHandler(DelLink_DataBinding);

			Literal LiteralTitle = (Literal)e.Item.FindControl( "LiteralTitle") ;
			LiteralTitle.DataBinding += new EventHandler(LiteralTitle_DataBinding);

			Literal LiteralText = (Literal)e.Item.FindControl( "LiteralText") ;
			LiteralText.DataBinding += new EventHandler(LiteralText_DataBinding);
		}

		private void RepeaterList_ItemCommand(object source, RepeaterCommandEventArgs e)
		{
			if ( e.CommandName == "Delete")
			{
				Resources.DeleteResource(int.Parse(e.CommandArgument.ToString())); 		
				RepeaterDataBind();
			}
		}

		private void EditLink_DataBinding(object sender, EventArgs e)
		{
			HyperLink link = (HyperLink)sender;
			RepeaterItem container = (RepeaterItem)link.NamingContainer;			
			link.NavigateUrl = Globals.UrlBase + "/admin/resources/resourceadmin.aspx?id=" + DataBinder.Eval( container.DataItem, "id" );
		}

		private void LiteralTitle_DataBinding(object sender, EventArgs e)
		{
			Literal l = (Literal)sender;
			RepeaterItem container = (RepeaterItem)l.NamingContainer;			
			l.Text = DataBinder.Eval(container.DataItem,"title").ToString();
			l.Text += "&nbsp;:"+DataBinder.Eval(container.DataItem,"code").ToString();
			l.Text += "&nbsp;ʾ:"+DataBinder.Eval(container.DataItem,"style").ToString();
		}

		private void LiteralText_DataBinding(object sender, EventArgs e)
		{
			Literal l = (Literal)sender;
			RepeaterItem container = (RepeaterItem)l.NamingContainer;			
			l.Text = DataBinder.Eval( container.DataItem, "data" ).ToString();
		}

		private void DelLink_DataBinding(object sender, EventArgs e)
		{
			LinkButton del = (LinkButton)sender;
			RepeaterItem container = (RepeaterItem)del.NamingContainer;		
			del.CommandArgument = DataBinder.Eval( container.DataItem, "id" ).ToString();
			del.CommandName = "Delete";			
		}		
	}
}
