using System;
using System.Data;
using System.Web.UI;
using System.Web.UI.WebControls;
using Meta.Web;
using Meta.Web.Security; 
using Meta.Web.Controls.Template; 
using MetaSite.Components.Providers;  

namespace MetaSite.Components.Controls.Views
{
	/// <summary>
	/// ManageRoles
	/// </summary>
	public class ManageRoles : BaseTemplateControl
	{
		Repeater RolesRepeater;		

		protected override void OnLoad(EventArgs e)
		{
			if ( !AdminSettings.InAdminRoles("ManageRoles"))
			{
				ForumPermission.RedirectOrExcpetion();			
			}

			if ( !Page.IsPostBack ) 
			{
				DataBind();
			}
			base.OnLoad( e );
		}

		protected override void AttachChildControls()
		{
			RolesRepeater = (Repeater)FindControl( "RolesRepeater" );
			RolesRepeater.ItemCommand += new RepeaterCommandEventHandler(RolesRepeater_ItemCommand);
			RolesRepeater.ItemCreated += new RepeaterItemEventHandler(RolesRepeater_ItemCreated);
			Context.Items.Add(PageHead.key,"ɫ");
		}

		public override void DataBind()
		{
			base.DataBind ();
			DataBindRoles();
		}

		protected void DataBindRoles() 
		{
			RolesRepeater.DataSource = new RolesProvider().GetRoles();   
			RolesRepeater.DataBind();
		}	

		private void RolesRepeater_ItemCommand(object source, RepeaterCommandEventArgs e)
		{
			switch( e.CommandName ) 
			{				
				case "Create":
					Control newforumButton = (Control)e.CommandSource;
					TextBox RoleName = newforumButton.NamingContainer.FindControl( "RoleName" ) as TextBox;	
					CreateRole( RoleName.Text);
					break;
			}
		}

		private void RolesRepeater_ItemCreated(object sender, RepeaterItemEventArgs e)
		{
			if ( e.Item.ItemType == ListItemType.Item || e.Item.ItemType == ListItemType.AlternatingItem ) 
			{			
				HyperLink RoleAdminLink = (HyperLink)e.Item.FindControl( "RoleAdminLink" );
				RoleAdminLink.DataBinding += new EventHandler(RoleAdminLink_DataBinding);

				Literal Description = (Literal)e.Item.FindControl( "Description") ;
				Description.DataBinding += new EventHandler(Description_DataBinding);	
			
				HyperLink MemberLink = (HyperLink)e.Item.FindControl( "MemberLink" );
				MemberLink.DataBinding += new EventHandler(MemberLink_DataBinding);
							
			}
			else if ( e.Item.ItemType == ListItemType.Header ) 
			{
				Button Create = (Button)e.Item.FindControl( "Create" );
				Create.DataBinding += new EventHandler(Create_DataBinding);
			}
		}

		private void RoleAdminLink_DataBinding(object sender, EventArgs e)
		{
			HyperLink RoleAdminLink = (HyperLink)sender;
			RepeaterItem container = (RepeaterItem)RoleAdminLink.NamingContainer;

			RoleAdminLink.Text = Convert.ToString( DataBinder.Eval( container.DataItem, "RoleName" ) );
			RoleAdminLink.NavigateUrl = Globals.UrlBase + "/admin/security/RoleAdmin.aspx?roleid=" + DataBinder.Eval( container.DataItem, "RoleId" );
		}

		private void MemberLink_DataBinding(object sender, EventArgs e)
		{
			HyperLink MemberLink = (HyperLink)sender;
			RepeaterItem container = (RepeaterItem)MemberLink.NamingContainer;
			MemberLink.Text = "鿴Ա";
			MemberLink.NavigateUrl = Globals.UrlBase + "/admin/security/RoleAdmin.aspx?roleid=" + DataBinder.Eval( container.DataItem, "RoleId" );
		}
	
		private void Description_DataBinding(object sender, EventArgs e)
		{
			Literal Description = (Literal)sender;
			RepeaterItem container = (RepeaterItem)Description.NamingContainer;
			string des = Convert.ToString( DataBinder.Eval( container.DataItem, "Description" ) );
			if(des != null)
				Description.Text = Context.Server.HtmlEncode(des);
		}

		private void CreateRole(string name)
		{
			Roles.CreateRole(name); 
			DataBindRoles();
		}	

		private void Create_DataBinding(object sender, EventArgs e)
		{
			Button Create = (Button)sender;
			Create.CommandName = "Create";			
		}
	}
}
