using System;
using System.Data;
using System.Web.UI;
using System.Web.UI.WebControls;
using Meta.Web;
using Meta.Web.Controls; 
using Meta.Web.Controls.Template;  
using Meta.Web.Security; 

namespace MetaSite.Components.Controls.Views
{
	/// <summary>
	/// ManageUser
	/// </summary>
	public class ManageUser : BaseTemplateControl
	{
		//DataColumnList UserList;
        GridView UserGrid;

		protected override void AttachChildControls()
		{
			if ( !AdminSettings.InAdminRoles("ManageUser"))
			{
				ForumPermission.RedirectOrExcpetion();			
			}

            UserGrid = FindControl("UserGrid") as GridView;
			//UserList.DataSource = new MetaSite.Components.Providers.UsersProvider().GetUsers();
            UserGrid.PageIndexChanging += new GridViewPageEventHandler(UserGrid_PageIndexChanging);

			Context.Items.Add(PageHead.key,"Ա");
		}

        void UserGrid_PageIndexChanging(object sender, GridViewPageEventArgs e)
        {
            UserGrid.PageIndex = e.NewPageIndex;
            DataBind(); 
        }

        protected override void OnInit(EventArgs e)
        {
            base.OnInit(e);
            DataBind();
        }


        public override void DataBind()
        {
            base.DataBind();

            UserGrid.Columns.Clear();

            HyperLinkField uname = new HyperLinkField();
            uname.DataNavigateUrlFields = new string[] { "UserId" };
            uname.DataNavigateUrlFormatString = Globals.UrlBase + "/admin/Security/memberadmin.aspx?userid={0}";
            uname.Target = "_blank";
            uname.DataTextField = "UserName";
            uname.HeaderText = "ʺ";
            uname.ItemStyle.Width = 160;
            UserGrid.Columns.Add(uname);

            BoundField email = new BoundField();
            email.HeaderText = "";
            email.DataField = "Email";   
            UserGrid.Columns.Add(email);

            HyperLinkField pass = new HyperLinkField();
            pass.DataNavigateUrlFields = new string[] { "UserId" };
            pass.DataNavigateUrlFormatString = Globals.UrlBase + "/admin/Security/Password.aspx?userid={0}";
            pass.Target = "_blank";           
            pass.HeaderText = "";
            pass.Text = "";
            pass.ItemStyle.Width = 100;
            pass.ItemStyle.HorizontalAlign = HorizontalAlign.Center;   
            UserGrid.Columns.Add(pass);

            HyperLinkField role = new HyperLinkField();
            role.DataNavigateUrlFields = new string[] { "UserId" };
            role.DataNavigateUrlFormatString = Globals.UrlBase + "/admin/Security/UserRolesAdmin.aspx?userid={0}";
            role.Target = "_blank";
            role.Text = "Ƴ/";
            role.HeaderText = "ɫ";
            role.ItemStyle.Width = 100;
            role.ItemStyle.HorizontalAlign = HorizontalAlign.Center;   
            UserGrid.Columns.Add(role);

            UserGrid.DataSource = new MetaSite.Components.Providers.UsersProvider().GetUsers();
            UserGrid.DataBind();
        }        

	}
}
