using System;
using System.Data;
using System.Web.UI;
using System.Web.UI.WebControls;
using Meta.Web;
using Meta.Web.Controls; 
using Meta.Web.Controls.Template;  

namespace MetaSite.Components.Controls.Views
{
	/// <summary>
	/// ModerateForum
	/// </summary>
	public class ModerateForum : BaseTemplateControl
	{		
		Literal Foruminfo;   
		DataGrid ModerateData; 
		
		protected override void AttachChildControls()
		{
			int fid = ContextData.Current.GetIntFromQueryString("forumid",-1);
			Forum f = Forums.GetForum(fid); 
			
			Foruminfo = FindControl("Foruminfo") as Literal;

			Foruminfo.Text = "<b>"+f.Name +"</B><br>"+f.Description; 

			ModerateData = FindControl("ModerateData") as DataGrid;			
			ModerateData.ItemCommand += new DataGridCommandEventHandler(ModerateData_ItemCommand);  		
			
			Context.Items.Add(PageHead.key,"");
		}

		protected override void OnInit(EventArgs e)
		{
			if ( !AdminSettings.InAdminRoles("Moderates"))
			{
				ForumPermission.RedirectOrExcpetion();			
			}
			base.OnInit (e);
			DataBind();
		}


		public override void DataBind()
		{
			base.DataBind ();

			ModerateData.Columns.Clear();
			HyperLinkColumn Subject = new HyperLinkColumn();
			Subject.DataNavigateUrlField = "postid";
			Subject.DataNavigateUrlFormatString = Globals.UrlBase + "/forum/ShowPost.aspx?postid={0}";
			//Subject.Target = "_blank";
			Subject.DataTextField = "Subject";
			Subject.HeaderText = "";
			ModerateData.Columns.Add(Subject); 

			HyperLinkColumn Author = new HyperLinkColumn();
			Author.DataNavigateUrlField = "userid";
			Author.DataNavigateUrlFormatString ="";
			Author.DataTextField = "PostAuthor";
			Author.HeaderText = "";
			Author.ItemStyle.HorizontalAlign = HorizontalAlign.Center;  

			ModerateData.Columns.Add(Author); 

			BoundColumn PostDate = new BoundColumn(); 
			PostDate.HeaderText = "ʱ";
			PostDate.DataField  = "PostDate";	
			PostDate.ItemStyle.HorizontalAlign = HorizontalAlign.Center;  
			ModerateData.Columns.Add(PostDate); 

			ButtonColumn Approve = new ButtonColumn();				
			Approve.CommandName = "Approve";
			Approve.Text = "׼";	
			Approve.ItemStyle.HorizontalAlign = HorizontalAlign.Center; 
			ModerateData.Columns.Add(Approve);

			ButtonColumn Edit = new ButtonColumn();				
			Edit.CommandName = "Edit";
			Edit.Text = "༭";	
			Edit.ItemStyle.HorizontalAlign = HorizontalAlign.Center; 
			ModerateData.Columns.Add(Edit);

			ButtonColumn Delete = new ButtonColumn();				
			Delete.CommandName = "Delete";
			Delete.Text = "ɾ";	
			Delete.ItemStyle.HorizontalAlign = HorizontalAlign.Center; 
			ModerateData.Columns.Add(Delete);		

			int fid = ContextData.Current.GetIntFromQueryString("forumid",-1);

			ModerateData.DataSource = Posts.GetNoApprovedPosts(fid);
			ModerateData.DataBind(); 
		}
	
		private void ModerateData_ItemCommand(object source, DataGridCommandEventArgs e)
		{
			DataTable dt = (DataTable)ModerateData.DataSource; 
			int postid = int.Parse(dt.Rows[e.Item.DataSetIndex]["postid"].ToString());

			switch(e.CommandName)
			{
				case "Approve":					
					Posts.Approve(postid);  
					DataBind();
					break;
				case "Edit":
					Page.Response.Redirect( Globals.UrlBase + "/admin/forums/PostAdmin.aspx?postid="+postid.ToString());  
					break;
				case"Delete":
					Posts.DeletePost(postid); 
					DataBind();
					break;
			}
		}
	}
}
