using System;
using System.Data;
using System.Collections; 
using System.Web.UI;
using System.Web.UI.WebControls;
using Meta.Web;
using Meta.Web.Controls.Template;  

namespace MetaSite.Components.Controls.Views
{
	/// <summary>
	/// Moderates
	/// </summary>
	public class Moderates : BaseTemplateControl
	{
		Repeater ModerateRepeater;        
		DropDownList ForumList;
		ImageButton AddPostLink; 

		protected override void OnLoad(EventArgs e)
		{
			if ( !AdminSettings.InAdminRoles("Moderates"))
			{
				ForumPermission.RedirectOrExcpetion();			
			}
			if ( !Page.IsPostBack ) 
			{
				DataBind();
			}
			base.OnLoad( e );
		}

		public override void DataBind()
		{
			base.DataBind ();
			ArrayList list = Posts.GetNoApprovedPostsInForum(); 
			aa:
			foreach( ForumPost fp in list)
			{
				if ( !fp.Forum.ResolvePermission(ContextData.Current.User).Administer) 
				{
					list.Remove(fp); 
					goto aa;
				}
			}

			ModerateRepeater.DataSource = list;//Posts.GetNoApprovedPostsInForum(); 
			ModerateRepeater.DataBind();
		}

		protected override void AttachChildControls()
		{
			ModerateRepeater = (Repeater)FindControl( "ModerateRepeater" );
			ModerateRepeater.ItemCreated += new RepeaterItemEventHandler(ModerateRepeater_ItemCreated);			
			Context.Items.Add(PageHead.key,"");

			ForumList = (DropDownList)FindControl( "ForumList" );
			AddPostLink = (ImageButton)FindControl( "AddPostLink" );

			AddPostLink.Click += new ImageClickEventHandler(AddPostLink_Click);

			if( !Page.IsPostBack)
			{
				DataTable tb = Forums.GetForumGroup();
				ForumList.DataSource = tb;
				ForumList.DataTextField = "name";
				ForumList.DataValueField = "forumid";
				ForumList.DataBind();  
			}
		}

		private void ModerateRepeater_ItemCreated(object sender, RepeaterItemEventArgs e)
		{
			if ( e.Item.ItemType == ListItemType.Item || e.Item.ItemType == ListItemType.AlternatingItem ) 
			{
			
				HyperLink MdForum = (HyperLink)e.Item.FindControl( "MdForum" );
				MdForum.DataBinding += new EventHandler(MdForum_DataBinding);

				HyperLink MdCount = (HyperLink)e.Item.FindControl( "MdCount" );
				MdCount.DataBinding += new EventHandler(MdCount_DataBinding);
	
			}			
		}
	
		private void MdForum_DataBinding(object sender, EventArgs e)
		{
			HyperLink hl = (HyperLink)sender;
			RepeaterItem container = (RepeaterItem)hl.NamingContainer;
			ForumPost fp = (ForumPost)container.DataItem; 
			hl.Text = fp.Forum.Name;  
			hl.NavigateUrl = Globals.UrlBase + "/admin/forums/moderateforum.aspx?forumid="+fp.Forum.ForumId.ToString();  
		}

		private void MdCount_DataBinding(object sender, EventArgs e)
		{
			HyperLink hl = (HyperLink)sender;
			RepeaterItem container = (RepeaterItem)hl.NamingContainer;
			ForumPost fp = (ForumPost)container.DataItem; 
			hl.Text = fp.Count.ToString();  
			hl.NavigateUrl = Globals.UrlBase + "/admin/forums/moderateforum.aspx?forumid="+fp.Forum.ForumId.ToString();  
		}

		private void AddPostLink_Click(object sender, ImageClickEventArgs e)
		{
			Page.Response.Redirect( Globals.UrlBase + "/admin/forums/PostAdmin.aspx?forumid="+ForumList.SelectedValue);  
		}
	}
}
