using System;
using System.Data; 
using System.Collections;
using System.Collections.Specialized;  
using System.Web.UI.WebControls;   
using System.ComponentModel;
using Meta.Web.Controls.Template;   
using Meta.Web.Security; 
using Meta.Web;
using Meta.Web.Controls;
using Meta.Web.Controls.MasterPages; 
using MetaSite.Components.Providers;

namespace MetaSite.Components.Controls.Views
{
	/// <summary>
	/// OfficialPostView
	/// </summary>
	public class OfficialPostView : BaseTemplateControl
	{
		PostData hander;
		Literal comment;
		PostText postText;

		ContextData context = ContextData.Current ;

		User user;
		Post post;

		protected override void AttachChildControls()
		{
			user = context.User;	
			int pid = context.GetIntFromQueryString("postid",-1);			
			post = Posts.GetPost(pid,true);
		
			hander = (PostData) FindControl("RPost");
			comment = (Literal) FindControl("comment");
			postText = (PostText) FindControl("postText");

			comment.Text = "<HR width=\"100%\" SIZE=\"1\">";
			comment.Text += "<B>\""+post.Subject +"\"<B>";
			comment.Text += "<HR width=\"100%\" SIZE=\"1\">";

			postText.Title = post.Subject;
			postText.Text = post.Body;
            postText.HeaderNavigates.Add("<font face=\"\">","");   
			postText.HeaderNavigates.Add("Դ:" + post.Author,"");   
			postText.HeaderNavigates.Add("&nbsp;:" + post.PostDate,"");
			postText.HeaderNavigates.Add("&nbsp;:" + post.TotalViews.ToString(),"");
            postText.HeaderNavigates.Add("</font>", "");   
			

			ForumPermission fp = post.Forum.ResolvePermission(context.User);
			if(!fp.View)
				ForumPermission.RedirectOrExcpetion(); 

			if ( fp.Administer || (context.User.UserId == post.User.UserId))
			{				

				if(fp.Edit)
				{
                    postText.HeaderNavigates.Add("<img src=\"" + Globals.UrlBase + "/" + Meta.Web.Configuration.Settings.Theme +   
                              "images/edit.gif\" border=0 width=\"16\" height=\"16\" hspace=\"1\" align=\"absmiddle\"/>༭",
						           Globals.UrlBase + "/admin/Forums/PostAdmin.aspx?postid="+post.PostId.ToString());   
				}

				if(fp.Delete)
				{
                    postText.HeaderNavigates.Add("<img src=\"" + Globals.UrlBase + "/" + Meta.Web.Configuration.Settings.Theme +   
						"images/del.gif\" border=0 width=\"16\" height=\"16\" hspace=\"1\" align=\"absmiddle\"/>ɾ",
						Globals.UrlBase + "/forum/deletepost.aspx?postid="+post.PostId.ToString());   
				}
			}

            postText.FooterNavigates.Add("鿴>>" ,Globals.UrlBase + "/showcomment.aspx?postid="+post.PostId.ToString()); 

			
			if( post.IsLocked || !fp.Reply)
			{
                hander.Visible = false;
				comment.Visible = false;
			}
			
		 	hander.Mode = PostMode.ReplyToPost; 	
			
			Context.Items.Add(PageHead.key,post.Subject);

			ContentContainer Container = (ContentContainer)Page.FindControl("Container");
            Meta.Web.Controls.MasterPages.Content MapPathRegion = null;
            foreach (Meta.Web.Controls.MasterPages.Content c in Container.Items)
			{
                if (c.ID == "MapPathRegion")
				{
                    MapPathRegion = c;
					break;
				}
			}

            if (MapPathRegion != null)
			{
                MapPath mapPath = (MapPath)MapPathRegion.FindControl("mapPath");
                mapPath.Nodes.Add(post.Subject, "");               
			}			
		}
	}
}
