using System;
using System.Data;
using System.Web.UI;
using System.Web.UI.WebControls;
using Meta.Web;
using Meta.Web.Security; 
using Meta.Web.Controls.Template;  
using MetaSite.Components.Providers; 
using MetaSite.Components.Controls;


namespace MetaSite.Components.Controls.Views
{
	/// <summary>
	/// PermissionAdmin
	/// </summary>
	public class PermissionAdmin: BaseTemplateControl
	{
		Label  RoleLabel;
		Label  ForumLabel;	
		Button CmdUpdate;

		PertmissionSet SetView;
		PertmissionSet SetRead;
		PertmissionSet SetPost;
		PertmissionSet SetReply;
		PertmissionSet SetEdit;
		PertmissionSet SetDelete;
		PertmissionSet SetAdmin; 
		
		ContextData context = ContextData.Current; 		
		
		ForumPermission perm;

		public PermissionAdmin()
		{
			if ( !AdminSettings.InAdminRoles("ManagePermissions"))
			{
				ForumPermission.RedirectOrExcpetion();			
			}
			perm = Permissions.GetPermission(context.GetIntFromQueryString("forumid",-1),context.GetIntFromQueryString("roleid",-1));				
		}

		protected override void AttachChildControls()
		{
			RoleLabel = (Label)FindControl("RoleLabel");
			ForumLabel = (Label)FindControl("ForumLabel");						
			
			CmdUpdate = (Button)FindControl( "CommandUpdate" );		
			CmdUpdate.Command += new CommandEventHandler(CmdUpdate_Command); 			
			
			RoleLabel.Text =  perm.Name;  
			ForumLabel.Text = Forums.GetForum(perm.ForumId).Name; 	

			SetView = FindControl("SetView") as PertmissionSet;			
			SetRead = FindControl("SetRead") as PertmissionSet;			
			SetPost = FindControl("SetPost") as PertmissionSet;			
			SetReply = FindControl("SetReply") as PertmissionSet;			
			SetEdit = FindControl("SetEdit") as PertmissionSet;			
			SetDelete = FindControl("SetDelete") as PertmissionSet;
			SetAdmin = FindControl("SetAdmin") as PertmissionSet;
		
			SetView.Allow = perm.View; 				
			SetRead.Allow = perm.Read; 		
			SetPost.Allow = perm.Post; 		
			SetReply.Allow = perm.Reply; 		
			SetEdit.Allow = perm.Edit; 		
			SetDelete.Allow = perm.Delete; 		
			SetAdmin.Allow = perm.Administer; 	
	
			Context.Items.Add(PageHead.key,"Ȩ");
		}

		private void CmdUpdate_Command(object sender, CommandEventArgs e)
		{
			perm.SetBit(Permission.View,SetView.AccessControlEntry);  
			perm.SetBit(Permission.Read,SetRead.AccessControlEntry);  
			perm.SetBit(Permission.Post,SetPost.AccessControlEntry);  
			perm.SetBit(Permission.Reply,SetReply.AccessControlEntry);  
			perm.SetBit(Permission.Edit,SetEdit.AccessControlEntry);  
			perm.SetBit(Permission.Delete,SetDelete.AccessControlEntry);  
			perm.SetBit(Permission.Administer,SetAdmin.AccessControlEntry);  

			Permissions.UpdatePermission( perm);
			context.Context.Response.Redirect(Globals.UrlBase + "/admin/forums/ManagePermissions.aspx?forumid="+perm.ForumId.ToString()); 
		}		
	}
}
