using System;
using System.Data; 
using System.Collections;
using System.Collections.Specialized;  
using System.Web.UI.WebControls; 
using System.Web.UI.HtmlControls;
using Meta.Web.Controls.Template;   
using Meta.Web.Controls;
using Meta.Web.Security; 
using Meta.Web;
using MetaSite.Components.Providers;

namespace MetaSite.Components.Controls.Views
{
	/// <summary>
	/// PostData
	/// </summary>
	public class PostData : BaseTemplateControl
	{
		TextBox PostSubject;
		InnerTextBox PostBody;	
		Button cmdEidt;
		MapPathbar mapPath; 	
		CheckBox IsLock;
		
		ContextData context = ContextData.Current ;

		User user;
		Post post;

		Forum forum;

		public PostData()
		{
			user = context.User;

			/*
			if (!Context.Request.IsAuthenticated)			
			{
				context.Context.Response.Redirect("../login.aspx");
				context.Context.Response.End(); 
			}
			*/

			Mode = PostMode.EditPost; 

			int pid = -2;

			if ( (pid = context.GetIntFromQueryString("postid",-1)) > 0)
			{
				post = Posts.GetPost(pid);
				Mode = PostMode.ReplyToPost; 
			}

			if ( context.GetIntFromQueryString("forumid",-1) > 0)
			{
				Mode = PostMode.NewPost; 
			}			
		}
		protected override void AttachChildControls()
		{			
			PostSubject = (TextBox) FindControl("PostSubject");
			PostBody = (InnerTextBox) FindControl("PostBody");		
			IsLock = (CheckBox) FindControl("IsLock");		
			cmdEidt = (Button) FindControl("cmdEidt");
			cmdEidt.Click += new EventHandler(cmdEidt_Click);

			if( RegionWidth.Value > 0)
			{
				PostSubject.Width = RegionWidth;
				PostBody.Width = RegionWidth;
			}

			if ( RegionHeight.Value > 0)
				PostBody.Height = RegionHeight;

			mapPath  = (MapPath)this.Parent.Parent.FindControl("mapPath");           
          
            string title = "";

            if (mapPath != null)
            {

                if (Mode == PostMode.NewPost)
                {
                    forum = Forums.GetForum(context.GetIntFromQueryString("forumid", -1));
                    mapPath.Nodes.Add(title = "", "");
                }
                else
                {
                    forum = Forums.GetForum(post.ForumId);

                    mapPath.Nodes.Add(post.Subject, Globals.UrlBase + "/forum/showpost.aspx?postid=" + post.ParentId);

                    if (Mode == PostMode.ReplyToPost)
                        mapPath.Nodes.Add(title = "", "");
                    else
                        mapPath.Nodes.Add(title = "༭", "");
                }
            }

			if ( Context.Items[PageHead.key] == null)  
    	    	Context.Items.Add(PageHead.key,title);
		
			Display();			
		}

		private void Display()
		{
			if (Mode == PostMode.ReplyToPost )
			{
				Permissions.AccessCheck(post.Forum,Permission.Reply,context.User,post);

				if (post.IsLocked )
				{
					context.Context.Response.Redirect("#");
					context.Context.Response.End(); 
				}

				PostSubject.Text = "Re:" + post.Subject;
			}
			else if (Mode == PostMode.EditPost)
			{
				Permissions.AccessCheck(post.Forum,Permission.Edit,context.User,post);

				PostSubject.Text = post.Subject;
				PostBody.Text = post.Body;
			}
			else if( Mode == PostMode.NewPost)
			{
				post = new Post(); 
				Permissions.AccessCheck(forum,Permission.Post,context.User,post);
			}

			if ( forum == null)
				forum = post.Forum; 

			ForumPermission fp = forum.ResolvePermission(context.User); 

			IsLock.Visible = ( Mode != PostMode.ReplyToPost && fp.Administer && fp.Edit && post.PostLevel == 1); 
		}

		private void cmdEidt_Click(object sender, EventArgs e)
		{
			Post addPost = new Post();
 
			if (Mode == PostMode.EditPost)
			{
				addPost = post;					
			}
		
			addPost.User    = user;
			addPost.Subject = PostSubject.Text;
			addPost.Body    = PostBody.InnerText;  
			addPost.IsLocked = IsLock.Checked; 


			addPost = AddPost(addPost,Mode);

			if ( addPost.Forum.ForumType > 0)
			{
				Page.Response.Redirect(Page.Request.Url.ToString());
			}

			switch(Mode)
			{
				case PostMode.EditPost:
					Page.Response.Redirect(Globals.UrlBase + "/forum/showpost.aspx?postid="+post.ParentId);
					break;
				case PostMode.NewPost:
					Page.Response.Redirect(Globals.UrlBase + "/forum/showforum.aspx?forumid="+context.GetIntFromQueryString("forumid",-1)); 
					break;
				case PostMode.ReplyToPost:
					Page.Response.Redirect(Globals.UrlBase +"/forum/showpost.aspx?postid="+post.ParentId);
					break;
			}
		}

		private Post AddPost (Post p, PostMode mode) 
		{
			Post newPost = null;

			switch (mode) 
			{

				case PostMode.NewPost:
					p.ForumId = context.GetIntFromQueryString("forumid",-1); 		
					p.PostLevel = 1;
					p.TotalViews = 0;					
					p.SortOrder = 0;
					p.IsApproved = (!p.Forum.IsActive);  
					newPost = Posts.AddPost(p);
					break;
			
				case PostMode.ReplyToPost:
					p.ForumId =post.ForumId; 
					p.ParentId = post.PostId;
					p.TotalViews = 0;			
					p.PostLevel = post.PostLevel + 1; 	
					p.TopicId = post.TopicId; 
					p.SortOrder = p.Topic.TotalPosts+1; 
					p.IsApproved = (!post.Forum.IsActive); 
					newPost = Posts.AddPost(p);
					break;

				case PostMode.EditPost:					
					Posts.UpdatePost(p);
					newPost = Posts.GetPost(p.PostId);
					break;
			}			

			return newPost;
		}
	
		public Unit RegionWidth 
		{
			get 
			{
				Object state = ViewState[ "Width" ];
				if ( state != null ) 
				{
					return (Unit) state;
				}
				return -1;
			}
			set { ViewState["Width"] = value; }
		}

		public Unit RegionHeight 
		{
			get 
			{
				Object state = ViewState[ "Height" ];
				if ( state != null ) 
				{
					return (Unit) state;
				}
				return -1;
			}
			set { ViewState["Height"] = value; }
		}
		
		public PostMode Mode 
		{
			get 
			{
				Object state = ViewState[ "Mode" ];
				if ( state != null ) 
				{
					return (PostMode) state;
				}
				return PostMode.NewPost;
			}
			set { ViewState["Mode"] = value; }
		}
	}
}
