using System;
using System.Data; 
using System.Collections;
using System.Collections.Specialized;  
using System.Web.UI.WebControls;   
using System.ComponentModel;
using Meta.Web.Controls.Template;   
using Meta.Web.Security; 
using Meta.Web;
using Meta.Web.Controls; 
using MetaSite.Components.Providers;

namespace MetaSite.Components.Controls.Views
{
	/// <summary>
	/// PostView 
	/// </summary>
	public class PostView : BaseTemplateControl
	{
		TemplateContainer PostsContainer;
		TemplateContainer subContainer;
        MapPath mapPath;	
		int PostId;
		ContextData context;
		Post post;
		DataRowCollection  rows;
		
		protected override void AttachChildControls()
		{
			context = ContextData.Current; 
			PostId = context.GetIntFromQueryString("PostId",-1);				
			post = Posts.GetPost(PostId,true);

			//ҳtitle
			Context.Items.Add(PageHead.key,post.Subject); 

			Permissions.AccessCheck(post.Forum,Permission.View,context.User,post);

			Menubar bar = (Menubar) FindControl("bar");	
			MenubarItem item = bar.Items[0];
			item.NavigateUrl = "../../forum/addpost.aspx?forumid="+post.ForumId;

			ForumPermission fp = post.Forum.ResolvePermission(context.User);

			if(!fp.View)
				ForumPermission.RedirectOrExcpetion(); 
 
			if(!fp.Post)
				bar.Visible = false;			
           
            mapPath = (MapPath)FindControl("mapPath");            
            mapPath.Nodes.Add(post.Subject, "");
            
			DataTable src = null;

			if( fp.Administer)
			    src = Posts.GetAdminPosts(PostId);
			else
				src = Posts.GetPosts(PostId);
			
			PostsContainer = (TemplateContainer) FindControl("PostsContainer");			
			ForumList list = (ForumList)PostsContainer.ListItems[0]; 
			list.DataSource = src;

            PostsContainer.Header.Text = "";
			
			string sj = "<img src=\""+ Globals.UrlBase +
				"/views/images/lock.gif\" border=0 width=\"16\" height=\"16\" hspace=\"1\" align=\"absmiddle\"/>";

			if (post.IsLocked)
			{			
				PostsContainer.Header.Text = sj;  
			}
			
			PostsContainer.Header.Text += "⣺"+post.Subject; 

			list.HeaderNavigates.Clear();
 
			list.HeaderNavigates.Add("ߣ",""); 
			list.HeaderNavigates.Add("{3}",Globals.UrlBase+"/user/showprofile.aspx?userid={4}" ); 
			list.HeaderNavigates.Add("{8}",""); 			
			

			if ( fp.Reply && !post.IsLocked)
			{
                list.HeaderNavigates.Add("<img src=\"" + Globals.UrlBase + "/" + Meta.Web.Configuration.Settings.Theme +   
                      "images/ref.gif\" border=0 width=\"16\" height=\"16\" hspace=\"1\" align=\"absmiddle\"/>",
					Globals.UrlBase + "/forum/Addpost.aspx?postid={0}");
                list.FooterNavigates.Add("<img src=\"" + Globals.UrlBase + "/" + Meta.Web.Configuration.Settings.Theme +   
                    "images/ref.gif\" border=0 width=\"16\" height=\"16\" hspace=\"1\" align=\"absmiddle\"/>",
					Globals.UrlBase + "/forum/Addpost.aspx?postid={0}");  
			}

 
			if ( fp.Administer || (context.User.UserId == post.User.UserId))
			{				

				if(fp.Edit)
				{
                    list.HeaderNavigates.Add("<img src=\"" + Globals.UrlBase + "/" + Meta.Web.Configuration.Settings.Theme +   
                        "images/edit.gif\" border=0 width=\"16\" height=\"16\" hspace=\"1\" align=\"absmiddle\"/>༭",
						Globals.UrlBase + "/forum/editpost.aspx?postid={0}");
                    list.FooterNavigates.Add("<img src=\"" + Globals.UrlBase + "/" + Meta.Web.Configuration.Settings.Theme +   
						"images/edit.gif\" border=0 width=\"16\" height=\"16\" hspace=\"1\" align=\"absmiddle\"/>༭"
						,Globals.UrlBase + "/forum/editpost.aspx?postid={0}");    
				}

				if(fp.Delete)
				{
					list.HeaderNavigates.Add("<img src=\""+ Globals.UrlBase+"/"+ Meta.Web.Configuration.Settings.Theme +   
						 "images/del.gif\" border=0 width=\"16\" height=\"16\" hspace=\"1\" align=\"absmiddle\"/>ɾ",
						Globals.UrlBase + "/forum/deletepost.aspx?postid={0}");
                    list.FooterNavigates.Add("<img src=\"" + Globals.UrlBase + "/" + Meta.Web.Configuration.Settings.Theme + 
                        "images/del.gif\" border=0 width=\"16\" height=\"16\" hspace=\"1\" align=\"absmiddle\"/>ɾ",
						Globals.UrlBase + "/forum/deletepost.aspx?postid={0}");    
				}
			}

			subContainer = (TemplateContainer) FindControl("subContainer");	
            list = (ForumList)subContainer.ListItems[0];

            if (src.Rows.Count < 2 && list.PageIndex == 1)
			{
				subContainer.Visible = false; return;
			}

			DataTable ps = src.Copy();

            if (list.PageIndex == 1)
            {
                ps.Rows[0].Delete();
                ps.AcceptChanges();
            }

			rows = ps.Rows; 
			
			list.DataSource = ps; 

			list.ListBinding += new ListBindingHander(list_ListBinding);
			
	
			/*if ( fp.Reply)
			{
				list.HeaderNavigates.Add("",Globals.UrlBase + "/forum/Addpost.aspx?postid={0}");
				list.FooterNavigates.Add("",Globals.UrlBase + "/forum/Addpost.aspx?postid={0}");  
			}*/

            subContainer.Header.Text = "";
			
			if (post.IsLocked)
				subContainer.Header.Text = sj;		

			subContainer.Header.Text += ""+ ps.Rows.Count.ToString()+"";    	
					
		}

		private bool list_ListBinding(object sender, ListBindingEventArgs e)
		{
            ForumList list = (ForumList)sender;		

			object[] o = (object[])e.Data;
			int pid = (int)o[0];
			int index = GetIndex(pid)+1;			

			Post subpost = Posts.GetPost(pid);

			ForumPermission fp = subpost.Forum.ResolvePermission(context.User);

			if ( index > 0)
	    		list.TitleFormat = "" + index.ToString() + ":{7}"; 

			list.HeaderNavigates.Clear();
			list.HeaderNavigates.Add("ߣ",""); 
			list.HeaderNavigates.Add("{3}",Globals.UrlBase+"/user/showprofile.aspx?userid={4}" ); 
		    list.HeaderNavigates.Add("{8}",""); 

			if ( fp.Reply && !post.IsLocked ) 
			{
                list.HeaderNavigates.Add("<img src=\"" + Globals.UrlBase + "/" + Meta.Web.Configuration.Settings.Theme +   
					"images/ref.gif\" border=0 width=\"16\" height=\"16\" hspace=\"1\" align=\"absmiddle\"/>",
					Globals.UrlBase + "/forum/Addpost.aspx?postid={0}");
                list.FooterNavigates.Add("<img src=\"" + Globals.UrlBase + "/" + Meta.Web.Configuration.Settings.Theme +   
					"images/ref.gif\"border=0 width=\"16\" height=\"16\" hspace=\"1\" align=\"absmiddle\"/>",
					Globals.UrlBase + "/forum/Addpost.aspx?postid={0}");  
			}  
          
			if ( fp.Administer || (context.User.UserId == subpost.User.UserId))
			{				

				if(fp.Edit)
				{
                    list.HeaderNavigates.Add("<img src=\"" + Globals.UrlBase + "/" + Meta.Web.Configuration.Settings.Theme +   
						"images/edit.gif\" border=0 width=\"16\" height=\"16\" hspace=\"1\" align=\"absmiddle\"/>༭",
						Globals.UrlBase + "/forum/editpost.aspx?postid={0}");    
					list.FooterNavigates.Add("<img src=\""+ Globals.UrlBase + "/"+ Meta.Web.Configuration.Settings.Theme +   
						"images/edit.gif\" border=0 width=\"16\" height=\"16\" hspace=\"1\" align=\"absmiddle\"/>༭",
						Globals.UrlBase + "/forum/editpost.aspx?postid={0}");    
				}

				if(fp.Delete)
				{
                    list.HeaderNavigates.Add("<img src=\"" + Globals.UrlBase + "/" + Meta.Web.Configuration.Settings.Theme +   
						"images/del.gif\" border=0 width=\"16\" height=\"16\" hspace=\"1\" align=\"absmiddle\"/>ɾ",
						Globals.UrlBase + "/forum/deletepost.aspx?postid={0}");    
					list.FooterNavigates.Add("<img src=\""+ Globals.UrlBase + "/"+ Meta.Web.Configuration.Settings.Theme +   
						 "images/del.gif\" border=0 width=\"16\" height=\"16\" hspace=\"1\" align=\"absmiddle\"/>ɾ",
						Globals.UrlBase + "/forum/deletepost.aspx?postid={0}");    
				}
			}

			return true;
		}
	
		private int GetIndex(int pid)
		{
			for(int i = 0;i< rows.Count;i++)
			{
				if ( (int)rows[i]["postid"]==pid)
					return i;
			}

			return -1;
		}
	}
}
