using System;
using System.Web.UI.WebControls;   
using Meta.Web.Controls.Template;   
using Meta.Web.Security; 
using Meta.Web;

using MetaSite.Components.Providers; 

namespace MetaSite.Components.Controls.Views
{
	/// <summary>
	/// Profile
	/// </summary>
	public class Profile : BaseTemplateControl
	{
		TextBox txtEmail;
		TextBox txtNick;
		TextBox txtName;
		TextBox txtAge;
		TextBox txtZone;
		TextBox txtWork;
		TextBox txtLabel;
		TextBox txtQQ;
		TextBox txtMsn;
		TextBox txtEmail2;
		TextBox txtPicUrl;

		HyperLink PasswordLink;
        
		Label lUser;
		Literal LiteralInfo;
		RadioButtonList listSex;
		CheckBox chkPic;
		Button  btOK;

		ContextData context;
		User user;

		CustomValidator CusValiNick;


		protected override void AttachChildControls()
		{
			context = ContextData.Current; 
			int id = context.GetIntFromQueryString("userid",-1);

			if(id == -1)
				user = context.User; 
			else
			{
				if ( !AdminSettings.InAdminRoles("ManageUser"))
				{
					ForumPermission.RedirectOrExcpetion();			
				}
				user = Users.GetUser(id); 
			}
 
			txtEmail = (TextBox) FindControl("txtEmail");	
			txtNick = (TextBox) FindControl("txtNick");	
			txtName = (TextBox) FindControl("txtName");	
			txtAge = (TextBox) FindControl("txtAge");	
			txtZone = (TextBox) FindControl("txtZone");	
			txtWork = (TextBox) FindControl("txtWork");	
			txtLabel = (TextBox) FindControl("txtLabel");	
			txtQQ = (TextBox) FindControl("txtQQ");	
			txtMsn = (TextBox) FindControl("txtMsn");	
			txtEmail2 = (TextBox) FindControl("txtEmail2");	
			txtPicUrl = (TextBox) FindControl("txtPicUrl");	

			PasswordLink = (HyperLink) FindControl("PasswordLink");	

			PasswordLink.NavigateUrl = Globals.UrlBase + "/admin/security/password.aspx?userid="+id.ToString();

			LiteralInfo = (Literal) FindControl("LiteralInfo");	
			listSex = (RadioButtonList) FindControl("listSex");	
			chkPic = (CheckBox) FindControl("chkPic");	
			
			lUser = (Label) FindControl("lUser");	
			
			btOK = (Button) FindControl("btOK");
			btOK.Click += new EventHandler(btOK_Click);
			
			CusValiNick = (CustomValidator) FindControl("CusValiNick");			
			CusValiNick.ServerValidate += new ServerValidateEventHandler(CusValiNick_ServerValidate);

			lUser.Text = user.UserName;

			txtNick.Enabled = false;

			string val = user.Propertys["Propertys"];
			
			CustomPropertys  Propertys = new CustomPropertys(val);		
	
			this.LiteralInfo.Text = 
            "<font face=''><P>עʱ:"+	user.CreationDate.ToString("G")+"</P>"+
			"<P>¼:"+ user.LastLoginDate .ToString("G")+"</P>"+
            "<P>:"+ user.Propertys["TotalTopics"] +"</P>"+
			"<P>:"+ user.Propertys["TotalPosts"] + "</P></FONT>";		 
		 
			txtEmail.Text = user.Email;
			txtNick.Text = user.NickName;
			txtName.Text = Propertys["name"];
			txtAge.Text = Propertys["age"];
			txtZone.Text = Propertys["zone"];
			txtWork.Text = Propertys["work"];
			txtLabel.Text = Propertys["label"];
			txtQQ.Text = Propertys["qq"];
			txtMsn.Text = Propertys["msn"];
			txtEmail2.Text = Propertys["email"];
			txtPicUrl.Text = Propertys["picurl"];	
		
			chkPic.Checked = (Propertys["ispic"]=="1");
			int index = 0;
			
			try
			{
				index = int.Parse(user.Propertys["sex"]);
			}
			catch{}

            listSex.Items[index].Selected = true;

			Context.Items.Add(PageHead.key,"ԱϢ");

		}

		private void btOK_Click(object sender, EventArgs e)
		{
			CustomPropertys Propertys = new CustomPropertys();

			user.Email = txtEmail.Text;
			//user.NickName = txtNick.Text;
			Propertys["name"] = txtName.Text;
			Propertys["age"] = txtAge.Text;
			Propertys["zone"] = txtZone.Text;
			Propertys["work"] = txtWork.Text;
			Propertys["label"] = txtLabel.Text;
			Propertys["qq"] = txtQQ.Text;
			Propertys["msn"] = txtMsn.Text;
			Propertys["email"] = txtEmail2.Text;
			Propertys["picurl"] = txtPicUrl.Text;	
			Propertys["ispic"] = (chkPic.Checked? "1":"0");

			

			int index = 0;

			for(int i = 0;i < 3;i++)
			{
				if ( listSex.Items[i].Selected)
				{
					index = i;
					break;
				}
			}

			Propertys["sex"] = index.ToString();

			user.Propertys["Propertys"] = Propertys.ValueString;  
 
			Users.UpdateUser(user); 
		}

		private void CusValiNick_ServerValidate(object source, ServerValidateEventArgs args)
		{
			CusValiNick.IsValid = true;// (!UsersProvider.ExistNick( txtNick.Text ));
		}
	}
}
