using System;
using System.Web.UI.WebControls;   
using Meta.Web.Controls.Template;   
using Meta.Web.Security; 
using Meta.Web;


namespace MetaSite.Components.Controls.Views
{
	/// <summary>
	/// UserProfile 
	/// </summary>
	public class ProfileView : BaseTemplateControl
	{
		Literal user;
		Literal logdate;
		Literal lastlog;
		Literal zone;
		Literal work;
		Literal QQ;
		Literal MSN;
		Literal Email;
		Literal posttotal;
		Literal pic;
		Literal label;

		protected override void AttachChildControls()
		{			
			int id = ContextData.Current.GetIntFromQueryString("userid",-1);	
			
            user = FindControl("user") as Literal;	
			
			logdate = FindControl("logdate") as Literal;	
            lastlog = FindControl("lastlog") as Literal;	
			zone = FindControl("zone") as Literal;	
			work = FindControl("work") as Literal;	
			QQ = FindControl("QQ") as Literal;	
			MSN = FindControl("MSN") as Literal;	
			Email = FindControl("Email") as Literal;	
			posttotal = FindControl("posttotal") as Literal;	
			pic = FindControl("pic") as Literal;	
			label = FindControl("label") as Literal;	

			User u = Users.GetUser(id);

			string val = u.Propertys["Propertys"];
		   
			user.Text = "<b><font face=''color='#000000'>"+u.UserName + "-"+u.NickName +"</font></b>";				
			CustomPropertys  Propertys = new CustomPropertys(val);	
	
			logdate.Text = u.CreationDate.ToString("G");
			lastlog.Text = u.LastLoginDate .ToString("G"); 
			posttotal.Text = ":"+u.Propertys["TotalTopics"] + ":"+u.Propertys["TotalPosts"];		
			
			zone.Text = Propertys["zone"];
			work.Text = Propertys["work"];
			label.Text = Propertys["label"];
			QQ.Text = Propertys["qq"];
			MSN.Text = Propertys["msn"];
			Email.Text = Propertys["email"];
			string p = Propertys["picurl"];
			if ( p != null &&  p!=string.Empty)
                pic.Text = "<img src=\""+ p+"\" bord=\"0\"/>";					

			Context.Items.Add(PageHead.key,"ԱϢ");

		}
	}
}
