using System;
using Meta.Web;
using Meta.Web.Controls; 

namespace MetaSite.Components.Controls.Views
{
	/// <summary>
	/// ResourceList
	/// </summary>
	public class ResourceList : TemplateContainer
	{		
		public int ShowStyle
		{
			get
			{
				object o = ViewState["ShowStyle"];
				return o==null? 1:(int)o;
			}
			set{ViewState["ShowStyle"] = value;}
		}

		protected override void Render(System.Web.UI.HtmlTextWriter writer)
		{	
			this.Header.Text = "վ";					

			SimpleList sl = new SimpleList();			
			sl.Navigates.Add("{1}",Globals.UrlBase + "/ShowResource.aspx?id={0}->_blank");			

			sl.DataSource = Resources.GetResources(ShowStyle);				
			sl.MaxLenght =18;	
			sl.PageSize = 100;			
			this.ListItems.Add(sl);  
			base.Render (writer);
		}
	}
}
