using System;
using System.Data;
using System.Web.UI;
using System.Web.UI.WebControls;
using Meta.Web;
using Meta.Web.Security; 
using Meta.Web.Controls.Template;  
using MetaSite.Components.Providers; 

namespace MetaSite.Components.Controls.Views
{
	/// <summary>
	/// RoleAdmin
	/// </summary>
	public class RoleAdmin : BaseTemplateControl
	{
		Label  IdLabel;
		TextBox TextName;
		TextBox TextDescription;	
		Button CommandUpdate;
		Button CommandDelete;
		ContextData context = ContextData.Current; 
		Role role;
		RolesProvider rp;

		public RoleAdmin()
		{
			if ( !AdminSettings.InAdminRoles("ManageRoles"))
			{
				ForumPermission.RedirectOrExcpetion();			
			}

			rp = new RolesProvider(); 
			role = rp.GetRole(context.GetIntFromQueryString("roleid",-1));		
					
			if (role == null)
			{				
				context.Context.Response.End();     
			}
		}

		protected override void AttachChildControls()
		{
			IdLabel = (Label)FindControl("IdLabel");
			TextName = (TextBox)FindControl( "TextName" );
			TextDescription = (TextBox)FindControl( "TextDescription" );			
			CommandUpdate = (Button)FindControl( "CommandUpdate" );
			CommandDelete = (Button)FindControl( "CommandDelete" );		
			CommandUpdate.Command += new CommandEventHandler(CommandUpdate_Command); 
			CommandDelete.Command += new CommandEventHandler(CommandDelete_Command);

            if (defaultRole(role))
                CommandDelete.Enabled = false;
			
		    IdLabel.Text = role.RoleId.ToString();  
			TextName.Text = role.RoleName;
			TextDescription.Text = role.Description; 

			if ( !rp.CanEdit( role.RoleId))
			{
                TextName.ReadOnly = true;
				TextDescription.ReadOnly = true;
				CommandUpdate.Enabled = false;
				CommandDelete.Enabled = false;
			}

			Context.Items.Add(PageHead.key,"ɫ");
		}

		private void CommandUpdate_Command(object sender, CommandEventArgs e)
		{
			role.RoleName = TextName.Text;
			role.Description = TextDescription.Text;			
			rp.UpdateRole(role);  
			context.Context.Response.Redirect(Globals.UrlBase + "/admin/security/ManageRoles.aspx"); 
		}

		private void CommandDelete_Command(object sender, CommandEventArgs e)
		{  
            if ( defaultRole(role))
                return;

			Roles.DeleteRole(role.RoleName); 
			context.Context.Response.Redirect(Globals.UrlBase + "/admin/security/ManageRoles.aspx"); 
		}

        private bool defaultRole(Role r)
        {
            string s = r.RoleName.ToLower();
            if (s != "systemadministrator" &&
                 s != "forumadministrator" &&
                  s != "everyone" &&
                   s != "registered users ")
                return true;

            return false;
        }
	}
}
