using System;
using System.Data; 
using System.Web.UI.WebControls;   
using System.ComponentModel;
using Meta.Web.Controls.Template;   
using Meta.Web.Security; 
using Meta.Web;

namespace MetaSite.Components.Controls.Views
{
	/// <summary>
	/// Search
	/// </summary>	
	public class Search : BaseTemplateControl
	{
		DropDownList qualifierList;
		TextBox tagText;
		ImageButton Searches;
		
		protected override void AttachChildControls()
		{			
			qualifierList = (DropDownList) FindControl("qualifierList");			
			tagText = (TextBox) FindControl("tagText");	

			Searches = (ImageButton) FindControl("Searches");
			Searches.Click += new System.Web.UI.ImageClickEventHandler(Searches_Click);
			//Searches.Attributes.Add("onclick","tosearche()");
			ContextData cd = ContextData.Current;

			if ( !Page.IsPostBack )
			{
				qualifierList.Items.Add("");
				qualifierList.Items.Add("");
				qualifierList.Items.Add(""); 				
 
				int n = cd.GetIntFromQueryString("sty",-2);
				string k = cd.QueryString["keywords"]; 
 
				if ( n > -1)
                    qualifierList.SelectedIndex = n;
				if ( k!=null)
					tagText.Text = k;
			}

			int m = cd.GetIntFromQueryString("mode",-2);

			if ( m > -1)
				SearchMode = m;

		}

		protected override void Render(System.Web.UI.HtmlTextWriter writer)
		{
			if ( SearchMode > 0)
			{               
				qualifierList.Visible = false;
			}
			base.Render (writer);
		}

		
		public int SearchMode 
		{
			get
			{
				object o = ViewState["SearchMode"]; 
				return o == null? 0 : (int)o;
			} 			
			set { ViewState["SearchMode"] = value; }
		}

		private void Searches_Click(object sender, System.Web.UI.ImageClickEventArgs e)
		{
			if ( SearchMode > 0)
		    	 qualifierList.SelectedIndex = 1;

			int n = qualifierList.SelectedIndex;
			string u = Globals.UrlBase + "/ShowSearch.aspx?sty="+n.ToString()+"&keywords="+tagText.Text+"&mode="+SearchMode.ToString();
			//string s = "<script language =javascript>function tosearche(){ window.open('"+u+"');}</script>";
			
			//Page.Response.Write(s);  
			//Page.Response.Redirect(Urls.Instance().FormatUrl( "searchview",n, tagText.Text,SearchMode));  ShowSearch.aspx?sty={0}^keywords={1}^mode={2}
		    Page.Response.Redirect(u);
			
		}
	}
}
