using System;
using System.Data; 
using System.Collections; 
using System.Web.UI.WebControls;   
using System.ComponentModel;
using Meta.Web.Controls.Template;   
using Meta.Web.Security; 
using Meta.Web.Controls;
using Meta.Web;
using MetaSite.Components.Providers;

namespace MetaSite.Components.Controls.Views
{
	/// <summary>
	/// SearchView
	/// </summary>
	public class SearchView : BaseTemplateControl
	{
		SearchList  searchList;
		ContextData context = ContextData.Current; 
		Literal SearchInfo;
	
		//<a href = 'forum/showpost.aspx?postid={0}' target=_blank >{7}</a>
		protected override void AttachChildControls()
		{
			int style = context.GetIntFromQueryString("sty",-1);
			string keywords = context.QueryString["keywords"];
			int mode = context.GetIntFromQueryString("mode",-1); 
 
			DataTable t = Searchs.GetSearchData(style,keywords,mode); 		
  
			searchList = (SearchList) FindControl("searchList");	
			SearchInfo = (Literal) FindControl("SearchInfo");	
			searchList.DataSource = t;
            searchList.AutoPaging = true; 
            
			SearchInfo.Text = "&nbsp;&nbsp;&nbsp;<b><font face='' color = '#ffffff'>Լ"+t.Rows.Count+"</font></b>";  
			searchList.TitleNavigates.Clear();
			if( mode == 0)
                searchList.TitleNavigates.Add("{7}",Globals.UrlBase + "/forum/showpost.aspx?postid={0}"); 
			else
				searchList.TitleNavigates.Add("{7}",Globals.UrlBase +"/ShowOfficialPost.aspx?postid={0}"); 
		
			Context.Items.Add(PageHead.key,"-"+ keywords);
		}
	}
}
