using System;
using System.Data; 
using System.Web.UI.WebControls;   
using System.ComponentModel;

using Meta.Web;
using Meta.Web.Security; 
using Meta.Web.Controls; 
using Meta.Web.Controls.Template; 

namespace MetaSite.Components.Controls.Views
{
	/// <summary>
	/// SubHeader
	/// </summary>
	public class SubHeader : BaseTemplateControl
	{
		Menubar topbar;	

		ContextData context; 		
		
		protected override void AttachChildControls()
		{
			context = ContextData.Current; 

			topbar = (Menubar) FindControl("topbar");				
		

			if (!context.Context.Request.IsAuthenticated )
			{				
				topbar.Items.Add( CreateMenubarItem("¼","~/login.aspx"));				
				topbar.Items.Add( CreateMenubarItem("ע","~/user/createuser.aspx"));			
			}
			else
			{
				AdminSettings.FileLocation =  "~/admin.config";

				if ( AdminSettings.InAdminRoles())
					topbar.Items.Add( CreateMenubarItem("","~/admin"));
				else 
				{
					topbar.Items.Add( CreateMenubarItem("ʻ","~/user/EditProfile.aspx"));
				}
			
				topbar.Items.Add( CreateMenubarItem("˳","~/logout.aspx"));
			}
		}

		public static MenubarItem CreateMenubarItem(string text,string url)
		{
			MenubarItem item = new MenubarItem();
			item.Text = text;
			item.NavigateUrl = url;  
		
			return item;
		}

		
	}
}
