using System;
using System.Data;
using System.Collections.Specialized;
using Meta.Web;
using Meta.Web.Controls; 
using Meta.Web.Controls.MasterPages; 
using MetaSite.Components.Providers;

namespace MetaSite.Components.Controls.Views
{
	/// <summary>
	/// TopicList
	/// </summary>
	public class TopicList : TemplateContainer
	{		
		public int ForumId
		{
			get{
				object o = ViewState["ForumId"];
				return o==null? -1:(int)o;
			}
			set{ViewState["ForumId"] = value;}
		}

        public int PageSize
        {
            get
            {
                object o = ViewState["PageSize"];
                return o == null ? 50 : (int)o;
            }
            set { ViewState["PageSize"] = value; }
        }

        public bool AllowPaging
        {
            get{
                object o = ViewState["AllowPaging"];
                return o == null ? true : (bool)o;
            }
            set { ViewState["AllowPaging"] = value; }
        }

        public string ListCss
        {
            get {
                object o = ViewState["ListCss"];
                return o == null ? string.Empty : (string)o;
            }
            set { ViewState["ListCss"] = value; }
        }
		
		protected override void OnLoad(EventArgs e)
		{
			int id = ContextData.Current.GetIntFromQueryString("forumid",-1);
            if (id > 0) ForumId = id;		
			base.OnLoad (e);
		}


		protected override void Render(System.Web.UI.HtmlTextWriter writer)
		{
			if ( ForumId == -1)
				return;
            Forum forum = Forums.GetForum(ForumId);

			this.Header.Text = "";			
			string name = forum.Name;
            this.Header.Text = name;		

			if ( !AllowPaging )
			{
                this.Header.ShowMoreButton = true;
				this.Header.MoreImageUrl = "~/[theme]images/more1.gif";
                
                if ( forum.IsGroup)
                    this.Header.MoreUrl = Globals.UrlBase + "/showgrouplist.aspx?parent=" + ForumId.ToString(); 
                else    
                    this.Header.MoreUrl = Globals.UrlBase + "/showlist.aspx?forumid=" + ForumId.ToString();               
			}         

			SimpleList sl = new SimpleList();

            if (ListCss != string.Empty)
                sl.CssClass = ListCss;

			sl.Navigates.Add("<FONT face=\"\">","");  			
			sl.Navigates.Add("{10}",Globals.UrlBase + "/ShowOfficialPost.aspx?postid={9}");
			sl.Navigates.Add("({4}/{7})","");
			sl.Navigates.Add("</FONT>","");           

            DataTable t = null;

            if (sl.AllowPaging = AllowPaging )
            {
                int pc = 0;
                t = Topics.GetTopics(ref pc, sl.PageSize, sl.PageIndex, ForumId);
                sl.Pagination.TotalData  = pc;
                sl.Pagination.CssClass = "default"; 
            }
            else
                t = Topics.GetTopics(ForumId, sl.PageSize);

           // if (t.Rows.Count == 0 && !AllowPaging)  //û,λʾ
			//	return;			

			sl.DataSource = t;			
			sl.MaxLenght = 20;
			
			this.ListItems.Add(sl);  

			base.Render (writer);

            if ( !AllowPaging)
		    	writer.Write("<br>"); 
		}

	}
}
