using System;  
using System.Data;
using System.Collections.Specialized;
using Meta.Web;
using Meta.Web.Controls;
using Meta.Web.Controls.MasterPages; 
using MetaSite.Components.Providers; 

namespace MetaSite.Components.Controls.Views
{
	/// <summary>
	/// TopicLists
	/// </summary>
	public class TopicLists : System.Web.UI.WebControls.WebControl
	{
        int parent = -1;
        
        public string ListCss
        {
            get
            {
                object o = ViewState["ListCss"];
                return o == null ? string.Empty : (string)o;
            }
            set { ViewState["ListCss"] = value; }
        }

		protected override void Render(System.Web.UI.HtmlTextWriter writer)
		{
            parent = ContextData.Current.GetIntFromQueryString("parent", -1);      
            DataTable t = (parent == -1) ? Forums.GetForumGroup(ForumType.News, 2) : Forums.GetForumGroup(parent, 2);          
			foreach ( DataRow dr in t.Rows )
			{
				Forum f = CommonDataProvider.FormatForum(dr);
				TopicList tl = new TopicList();
                tl.PageSize = 20;
                tl.AllowPaging = false;
                if (ListCss != string.Empty)
                    tl.ListCss = ListCss;
 
				tl.ForumId = f.ForumId;
				this.Controls.Add(tl);  
			}

			base.Render (writer);
		}
	}
}
