using System;
using System.Data; 
using System.Collections;
using System.Collections.Specialized; 
using System.Web.UI.WebControls;   
using System.ComponentModel;
using Meta.Web.Controls.Template;   
using Meta.Web.Security; 
using Meta.Web;
using Meta.Web.Controls; 
using MetaSite.Components.Providers;

namespace MetaSite.Components.Controls.Views
{
	/// <summary>
	/// Topics 
	/// </summary>
	public class TopicView : BaseTemplateControl
	{
		//TemplateContainer TopicsContainer;
        MapPath mapPath;
		Menubar bar;
		Forum forum;
		int forumId;
        GridView TopicGrid;
        Pagination pagination;
		
		protected override void AttachChildControls()
		{
			ContextData context = ContextData.Current; 			
			
			forumId = context.GetIntFromQueryString("forumid",-1);		
			forum = Forums.GetForum(forumId); 

			//ҳtitle
			Context.Items.Add(PageHead.key,forum.Name); 

			Permissions.AccessCheck(forum,Permission.View,context.User,null);

            //-------------------
            mapPath = (MapPath)FindControl("mapPath");
            mapPath.TopNode = 1;           

			bar = (Menubar) FindControl("bar");	
			MenubarItem item = bar.Items[0];
			item.NavigateUrl = "~/forum/addpost.aspx?forumid="+forumId;

			ForumPermission fp = forum.ResolvePermission(context.User);

			if(!fp.View)
				ForumPermission.RedirectOrExcpetion(); 
 
			if(!fp.Post)
				bar.Visible = false;


            pagination = FindControl("Pagination") as Pagination;
            TopicGrid = FindControl("TopicGrid") as GridView;
			//TopicsContainer = (TemplateContainer) FindControl("TopicsContainer");			
			//TopicsContainer.ListItems[0].DataSource = Topics.GetTopics(forumId); 	
           
            TopicGrid.PageIndexChanging += new GridViewPageEventHandler(TopicGrid_PageIndexChanging);
           
		}

        void TopicGrid_PageIndexChanging(object sender, GridViewPageEventArgs e)
        {
            TopicGrid.PageIndex = e.NewPageIndex;
            DataBind();
        }
     
        protected override void OnInit(EventArgs e)
        {
            base.OnInit(e);
            if (!Page.IsPostBack)
            {               
                DataBind();
            }
        }


        public override void DataBind()
        {
            base.DataBind();

            TopicGrid.Columns.Clear();

            HyperLinkField subject = new HyperLinkField();
            subject.DataNavigateUrlFields = new string[] { "PostId" };
            subject.DataNavigateUrlFormatString = Globals.UrlBase + "/forum/showpost.aspx?postid={0}";
            //subject.Target = "_blank";
            subject.DataTextField = "Subject";
            subject.HeaderText = "";
            TopicGrid.Columns.Add(subject);

            HyperLinkField author = new HyperLinkField();
            author.DataNavigateUrlFields = new string[] { "UserId" };
            author.DataNavigateUrlFormatString = Globals.UrlBase + "/user/showprofile.aspx?userid={0}";
            //author.Target = "_blank";
            author.DataTextField = "PostAuthor";
            author.HeaderText = "";
            author.ItemStyle.Width = 200;
            TopicGrid.Columns.Add(author);

            BoundField views = new BoundField();
            views.HeaderText = "";
            views.DataField = "TotalViews";
            views.ItemStyle.HorizontalAlign = HorizontalAlign.Center;
            views.ItemStyle.Width = 100;
            TopicGrid.Columns.Add(views);

            BoundField post = new BoundField();
            post.HeaderText = "ظ";
            post.DataField = "TotalPosts";
            post.ItemStyle.HorizontalAlign = HorizontalAlign.Center;
            post.ItemStyle.Width = 100;
            TopicGrid.Columns.Add(post);

            int pc = 0;
            DataTable tb = Topics.GetTopics(ref pc, pagination.PageSize,pagination.PageIndex,forumId);
            pagination.TotalData = pc;
           
            TopicGrid.DataSource = tb;
            TopicGrid.DataBind();
        }  
	}
}
