using System;
using System.Data;
using System.Web.UI;
using System.Web.UI.WebControls;
using Meta.Web;
using Meta.Web.Security; 
using Meta.Web.Controls.Template;  
using MetaSite.Components.Providers; 

namespace MetaSite.Components.Controls.Views
{
	/// <summary>
	/// UserRolesAdmin
	/// </summary>
	public class UserRolesAdmin : BaseTemplateControl
	{		
		ListBox RoleList;
		ListBox InUserList;

		Button CmdUpdate;
		Button CmdAdd;
		Button CmdRem;

		ContextData context = ContextData.Current; 
		User user;
		

		public UserRolesAdmin()
		{	
			if ( !AdminSettings.InAdminRoles("ManageUser"))
			{
				ForumPermission.RedirectOrExcpetion();			
			}

			user = Users.GetUser(context.GetIntFromQueryString("userid",-1));		
					
			if (user == null)
			{				
				context.Context.Response.End();     
			}
		}

		protected override void AttachChildControls()
		{
			RoleList = (ListBox)FindControl("RoleList");
			InUserList = (ListBox)FindControl( "InUserList" );
					
			CmdUpdate = (Button)FindControl( "CmdUpdate" );
			CmdAdd = (Button)FindControl( "CmdAdd");		
			CmdRem = (Button)FindControl( "CmdRem");	
		
			CmdUpdate.Command += new CommandEventHandler(CmdUpdate_Command);
			CmdAdd.Command += new CommandEventHandler(CmdAdd_Command);
			CmdRem.Command += new CommandEventHandler(CmdRem_Command);

			if ( !Page.IsPostBack )
			{
				string[] rs = Roles.GetAllRoles();
				string[] irs = Roles.GetRolesForUser(user.UserName);
			
				foreach( string r in rs)
				{
					if ( !Roles.IsUserInRole(user.UserName,r))
					{
						RoleList.Items.Add(new ListItem(r));   
					}
				}

				InUserList.DataSource = irs;
				InUserList.DataBind(); 
			}	
		
			Context.Items.Add(PageHead.key,"Աɫ");
		}

		private void CmdUpdate_Command(object sender, CommandEventArgs e)
		{
			string[] rs = new string[RoleList.Items.Count];

			for(int i = 0; i < rs.Length; i++)
			{
				rs[i] = RoleList.Items[i].Text;  
			}

			Roles.RemoveUserFromRoles(user.UserName,rs);

			string r = string.Empty; 

			for(int i = 0; i < InUserList.Items.Count; i++)
			{
				if (!Roles.IsUserInRole(user.UserName, InUserList.Items[i].Text))
				{
					if ( r.Length > 0)
						r += ",";

					r += InUserList.Items[i].Text;
				}				
			}

			if ( r != string.Empty)
			{
				rs = r.Split(','); 
				Roles.AddUserToRoles(user.UserName,rs);
			}

			context.Context.Response.Redirect(Globals.UrlBase + "/admin/security/ManageUser.aspx"); 
		}

		private void CmdAdd_Command(object sender, CommandEventArgs e)
		{
			if (  RoleList.SelectedIndex > -1)
			{
				string select = RoleList.SelectedItem.Text;
    
				RoleList.Items.Remove(select);

				InUserList.Items.Add(new ListItem(select));  
			}
		}

		private void CmdRem_Command(object sender, CommandEventArgs e)
		{
			if (  InUserList.SelectedIndex > -1)
			{
				string select = InUserList.SelectedItem.Text;
    
				InUserList.Items.Remove(select);

				RoleList.Items.Add(new ListItem(select));  
			}
		}
	}
}
