using System;
using System.Data; 
using System.Collections; 
using System.Web.Caching; 
using Meta.Web; 
using Meta.Web.Security; 
using MetaSite.Components.Providers; 

namespace MetaSite.Components
{
	/// <summary>
	/// Forum
	/// </summary>
	public class Forum
	{
		int     _ForumId;
		bool    _IsActive;
		string  _Name;
		string  _Description;
		DateTime  _CreationDate;
		int       _SortOrder;
		int       _TotalPosts;
		int       _TotalTopics;
		ForumType _ForumType; 
		bool      _IsSearchable;
        //07-4-16
        int parentId = -1;
        bool isGroup = false;

		public ForumPermission ResolvePermission( User user ) 
		{
			ForumPermission pbMaster = new ForumPermission();
			//string[] roles = Roles.GetRolesForUser(user.UserName);
			string[] roles  = new RolesProvider().GetRolesForUser(user.UserName); 
			ForumPermission pb = null;
			foreach(string role in roles)
			{
				for(int i = 0;i< PermissionSet.Count;i++){
					pb = PermissionSet[i] as ForumPermission; 					
					if(pb.Name == role){
						pbMaster.Merge(pb);
						break;
					}
				}
			}
			return pbMaster;
		}
		
		ArrayList permissions;
		public ArrayList PermissionSet 
		{
			get {
				if ( permissions == null){
					permissions = Permissions.GetPermissions(this.ForumId);  
				}
				return permissions;
			}
			set { permissions = value; }
		}

		#region" propertys"

		public enum ForumSortBy 
		{
			SortOrder,
			Name,
			Topic,
			Post,
			LastPost,
			LastPostDescending
		}

		ForumSortBy _SortBy = ForumSortBy.SortOrder; 

		public ForumSortBy SortBy
		{
			get { return _SortBy;}
			set{ _SortBy = value;}
		}

		public int ForumId
		{
			get { return _ForumId;}
			set{ _ForumId = value;}
		}

        public int ParentId
        {
            get { return parentId; }
            set { parentId = value; }
        }

		public bool IsActive
		{
			get { return _IsActive;}
			set{ _IsActive = value;}
		}

		public string Name
		{
			get { return _Name;}
			set{ _Name = value;}
		}

		public string Description
		{
			get { return _Description;}
			set{ _Description = value;}
		}

		public DateTime CreationDate
		{
			get { return _CreationDate;}
			set{ _CreationDate = value;}
		}

		public int SortOrder
		{
			get { return _SortOrder;}
			set{ _SortOrder = value;}
		}
	
		public int TotalPosts
		{
			get { return _TotalPosts;}
			set{ _TotalPosts = value;}
		}

		public int TotalTopics
		{
			get { return _TotalTopics;}
			set{ _TotalTopics = value;}
		}

		public ForumType ForumType
		{
			get { return _ForumType;}
			set{ _ForumType = value;}
		}

		public bool IsSearchable
		{
			get { return _IsSearchable;}
			set{ _IsSearchable = value;}
		}

        public bool IsGroup
        {
            get { return isGroup; }
            set { isGroup = value; }
        }
		
		#endregion
	}
}
