using System;
using System.Data; 
using System.Web.Caching;  
using Meta.Web;
using Meta.Web.Security; 
using MetaSite.Components.Providers; 

namespace MetaSite.Components
{
	/// <summary>
	/// Forums
	/// </summary>
	public class Forums
	{
		const string key = "ForumGroup";

		public static DataTable GetForumGroup()
		{
			DataTable t = CacheData.Get(key) as DataTable;

			if ( t == null)
			{
				t = CommonDataProvider.GetForumGroup();
				CacheData.Insert(key,t,6);
			}
		
			return t;
		}       

		public static DataTable GetForumGroup(ForumType type,int group)
		{
            string _key = string.Format("ForumGroup-{0}-{1}", type, group);           

            DataTable t = CacheData.Get(_key) as DataTable;

            if (t == null)
            {
                t = CommonDataProvider.GetForumGroup((int)type, group);
                CacheData.Insert( _key, t, 6);
            }

            return t;
		}

        public static DataTable GetForumGroup(int parentId, int group)
        {
            string _key = string.Format("ForumGroup-c-{0}-{1}", parentId,group);
            DataTable t = CacheData.Get(_key) as DataTable;

            if (t == null)
            {
                if ( group == 0 )
                   t = CommonDataProvider.GetForumGroup(parentId, false);
               if (group == 1)
                   t = CommonDataProvider.GetForumGroup(parentId, true);
               else                 
                   t = CommonDataProvider.GetForumGroup(parentId);
               CacheData.Insert(_key, t, 6);
            }

            return t;
        }

		public static Forum GetForum(int forumId)
		{
            string _key = string.Format("Forum-{0}", forumId);
            Forum f = CacheData.Get(_key) as Forum;
		
			if ( f == null)
			{
                 f = CommonDataProvider.GetForum(forumId);
                 CacheData.Insert(_key,f, 6);
			}					
			
			return f;
		}

		public static void UpdateForum (Forum forum)
		{
			CommonDataProvider.UpdateForum( forum);
			CacheData.Remove(key); 
		}

		public static void DeleteForum (Forum forum)
		{
            Permissions.RemovePermission(forum.ForumId);   
			CommonDataProvider.DeleteForum( forum);
			CacheData.Remove(key); 
		}

		public static void ChangeForumSortOrder(int forumId,bool moveUp)
		{
			CommonDataProvider.ChangeForumSortOrder( forumId,moveUp);
		}

		public static Forum CreateForum(string name,ForumType type,int parentId)
		{
			CacheData.Remove(key);
            return CommonDataProvider.CreateForum(name, type, parentId,false); 
		}

        public static Forum CreateForum(string name, ForumType type, int parentId,bool group)
        {
            CacheData.Remove(key);
            Forum f = CommonDataProvider.CreateForum(name, type, parentId, group);
            defaultPermission(f.ForumId); 
            return f;
        }

        public static Forum CreateForum(string name, ForumType type)
        {
            CacheData.Remove(key);
            Forum f = CommonDataProvider.CreateForum(name, type, -1, false);
            defaultPermission(f.ForumId); 
            return f;
        }    

        private static void defaultPermission(int forumId)
        {
            ForumPermission fp = new ForumPermission();
            fp.SetBit(Permission.View, AccessControlEntry.Allow);
            fp.SetBit(Permission.Read, AccessControlEntry.Allow);
            fp.SetBit(Permission.Post, AccessControlEntry.Allow);
            fp.SetBit(Permission.Reply, AccessControlEntry.Allow);
            fp.SetBit(Permission.Edit, AccessControlEntry.Allow);
            fp.SetBit(Permission.Delete, AccessControlEntry.Allow);
            fp.SetBit(Permission.Administer, AccessControlEntry.Allow);           
            fp.RoleId = Roles.GetRole("SystemAdministrator").RoleId;
            fp.ForumId = forumId;  
			Permissions.AddPermission(fp);

            fp = new ForumPermission();
            fp.SetBit(Permission.View, AccessControlEntry.Allow);
            fp.SetBit(Permission.Read, AccessControlEntry.Allow);
            fp.SetBit(Permission.Post, AccessControlEntry.Allow);
            fp.SetBit(Permission.Reply, AccessControlEntry.Allow);
            fp.SetBit(Permission.Edit, AccessControlEntry.Allow);
            fp.SetBit(Permission.Delete, AccessControlEntry.Allow);
            fp.SetBit(Permission.Administer, AccessControlEntry.Allow);  
            fp.RoleId = Roles.GetRole("ForumAdministrator").RoleId;
            fp.ForumId = forumId;
            Permissions.AddPermission(fp);

            fp = new ForumPermission();
            fp.SetBit(Permission.View, AccessControlEntry.Allow);
            fp.SetBit(Permission.Read, AccessControlEntry.Allow);
            fp.SetBit(Permission.Post, AccessControlEntry.Deny);
            fp.SetBit(Permission.Reply, AccessControlEntry.Deny);
            fp.SetBit(Permission.Edit, AccessControlEntry.Deny);
            fp.SetBit(Permission.Delete, AccessControlEntry.Deny);
            fp.SetBit(Permission.Administer, AccessControlEntry.Deny);  
            fp.RoleId = Roles.GetRole("Everyone").RoleId;
            fp.ForumId = forumId;
            Permissions.AddPermission(fp);

            fp = new ForumPermission();
            fp.SetBit(Permission.View, AccessControlEntry.Allow);
            fp.SetBit(Permission.Read, AccessControlEntry.Allow);
            fp.SetBit(Permission.Post, AccessControlEntry.Allow);
            fp.SetBit(Permission.Reply, AccessControlEntry.Allow);
            fp.SetBit(Permission.Edit, AccessControlEntry.Deny);
            fp.SetBit(Permission.Delete, AccessControlEntry.Deny);
            fp.SetBit(Permission.Administer, AccessControlEntry.Deny);  
            fp.RoleId = Roles.GetRole("Registered Users ").RoleId;
            fp.ForumId = forumId;
            Permissions.AddPermission(fp); 
        }
	}
}
