using System;
using System.IO;
using System.Web;   
using Meta.Web.Security;  

namespace MetaSite.Components
{
	/// <summary>
	/// PostImage
	/// </summary>
	public class _Image
	{
		int _ImageId;
		DateTime _CreationDate;
		string _FileName;	
		string _RealFileName;
		string _ContentType;
		int _ContentSize;		
		byte[] content = new byte[0];

		public _Image()	{}
		public _Image (HttpPostedFile postedFile) 
		{
			DoPostImage(postedFile, Users.GetUser().UserId);  
		}

		public _Image (HttpPostedFile postedFile, int userId) 
		{
			DoPostImage(postedFile, userId);  
		}

		private void DoPostImage(HttpPostedFile postedFile, int userId)
		{	
			_CreationDate = DateTime.Now; 
			_ContentSize = postedFile.ContentLength;
			_ContentType = postedFile.ContentType;			
			_FileName =  Path.GetFileName(postedFile.FileName);
			_RealFileName = System.Guid.NewGuid().ToString() + Path.GetExtension( postedFile.FileName );
			content = new Byte[ContentSize];			
			postedFile.InputStream.Read(content, 0, ContentSize);
		}

		public static string GetImagePath(int ForumId)
		{
			string path = Path.Combine( SiteSettings.Setting("ImagePath") + "/", ForumId.ToString()+"/");
			return HttpContext.Current.Server.MapPath( path );
		}

		public static string GetImagePath(int userId, string filename)
		{
			return Path.Combine(GetImagePath(userId) , filename);
		}

		public Byte[] Content 
		{
			get { return content; }
			set { content = value;}
		}
		
		public int ContentSize 
		{
			get { return _ContentSize;}
			set { _ContentSize = value;}
		}

		public string ContentType 
		{
			get { return _ContentType;}
			set { _ContentType = value;}
		}

		public string FileName 
		{
			get { return _FileName;}
			set { _FileName = value;}
		}

		public int ImageId 
		{
			get { return _ImageId; }
			set { _ImageId = value; }
		}

		public string RealFileName 
		{
			get { return _RealFileName; }
			set { _RealFileName = value; }
		}

		public DateTime CreationDate 
		{
			get { return _CreationDate;}
			set { _CreationDate = value;}
		}
	}
}
