using System;
using System.Data;
using Meta.Web; 
using MetaSite.Components.Providers; 

namespace MetaSite.Components
{
	/// <summary>
	/// ImageIndexs
	/// </summary>
	public class ImageIndexs
	{
		public static DataTable GetIndexs()
		{
            string key = "Index";
            DataTable t = CacheData.Get(key) as DataTable;

            if (t == null)
            {
                t = CommonDataProvider.GetIndexs();
                CacheData.Insert(key, t, 6);
            }

			return t;
		}
	
		public static ImageIndex GetIndex(int postId)
		{
            string key = string.Format("Index-{0}",postId.ToString());
            ImageIndex iid = CacheData.Get(key) as ImageIndex;

            if (iid == null)
            {
                iid = CommonDataProvider.GetIndex(postId);	
                CacheData.Insert(key, iid, 6);
            }

            return iid;
		}

		public static void CreateIndex(ImageIndex index)
		{
			CommonDataProvider.CreateIndex(index);
            CacheData.Remove("Index"); 
		}

		public static void UpdateIndex (ImageIndex index)
		{
    		CommonDataProvider.UpdateIndex(index);
            CacheData.Remove("Index");
            CacheData.Remove(string.Format("Index-{0}",index.PostId.ToString())); 
		}

		public static void DeleteIndex (int postId)
		{
			CommonDataProvider.DeleteIndex(postId);
            CacheData.Remove("Index");
            CacheData.Remove(string.Format("Index-{0}", postId.ToString())); 
		}

	}
}
