using System;
using System.Data;
using Meta.Web; 
using MetaSite.Components.Providers;  

namespace MetaSite.Components
{
	/// <summary>
	/// Links
	/// </summary>
	public class Links
	{
		public static DataTable GetLinks() 
		{
            string key = "Links";
            DataTable t = CacheData.Get(key) as DataTable;

            if (t == null)
            {
                t = CommonDataProvider.GetLinks(); 
                CacheData.Insert(key, t, 6);
            }
			return t; 
		}
		
		public static void AddLink(string title,string url)
		{
			CommonDataProvider.AddLink(title,url);
            CacheData.Remove("Links");
		}

		public static void ChangeLinkSortOrder(int linkId,bool moveUp)
		{
			CommonDataProvider.ChangeLinkSortOrder(linkId,moveUp);
            CacheData.Remove("Links");
		}

		public static void DeleteLink(int linkId)
		{
			CommonDataProvider.DeleteLink(linkId);
            CacheData.Remove("Links");
		}
	}
}
