using System;
using System.Collections;
using Meta.Web.Security;  
using MetaSite.Components.Providers;  

namespace MetaSite.Components
{
	/// <summary>
	/// Permissions
	/// </summary>
	public class Permissions
	{
		public Permissions(){}	
		

		public static bool ValidatePermissions(Forum forum, Permission permission, User user)
		{
			return ForumPermission.Validate(forum,permission,user);
		}	

		public static void AccessCheck (Forum forum, Permission permission, User user)
		{
			AccessCheck(forum,permission,user,null);
		}       

		public static void AccessCheck (Forum forum, Permission permission, User user, Post post)
		{			
			ForumPermission.AccessCheck(forum,permission,user,post);
		}

		public static void UpdatePermission (ForumPermission fp) 
		{
			CommonDataProvider.UpdatePermission(fp); 
		}

		public static void RemovePermission (ForumPermission fp) 
		{
			CommonDataProvider.RemovePermission(fp); 
		}

        public static void RemovePermission(int forumId)
        {
            CommonDataProvider.RemovePermission(forumId);
        }

        public static void RemovePermission(Role r)
        {
            CommonDataProvider.RemovePermission(r);
        }
	
		public static void AddPermission (ForumPermission fp) 
		{
			CommonDataProvider.AddPermission(fp); 			
		}

		public static ArrayList GetPermissions(int forumId)
		{
			return CommonDataProvider.GetPermissions(forumId); 
		}

		public static ForumPermission GetPermission(int forumId,int roleId)
		{
			return CommonDataProvider.GetPermission(forumId,roleId); 
		}
	}
}
