using System;
using System.Data; 
using System.Collections; 
using Meta.Web;
using Meta.Web.Controls; 
using Meta.Web.Security;

namespace MetaSite.Components
{
	/// <summary>
	/// Post
	/// </summary>
	public class Post : CustomPropertys,IDataSourceItem 
	{
		int     _PostId    = 0;				   
		int     _TopicId  = 0;			
		int     _ParentId  = 0;	
		int     _PostLevel = 1;	
		int     _ForumId = 0;			
		int     _SortOrder = 0;	
		string  _Subject = string.Empty;
		string  _Author;
		bool    _IsApproved = true;  //׼
		bool    _IsLocked;      //
		int     _TotalViews = 0; //
		string  _Body;	
			
		DateTime _PostDate = DateTime.Now;		
		Forum    _Forum;
		Topic    _Topic;
		User     _User;  				
	
		public User User 
		{
			get{ return _User;}
			set{ _User = value;}
		}
	
		public int PostId 
		{
			get { return _PostId; }
			set { _PostId = (value < 0 ? 0: value);}			
		}

		public int PostLevel 
		{
			get { return _PostLevel; }
			set { _PostLevel = (value < 1 ? 1: value);}			
		}
	
		public bool IsLocked 
		{
			get { return _IsLocked; }            
			set { _IsLocked = value; }
		}

		public int TotalViews 
		{
			get{ return _TotalViews;}
			set{ _TotalViews = value;}
		}

		public int TopicId 
		{
			get { return _TopicId; }
			set { _TopicId = (value < 0 ? 0: value);}			
		}

		public Topic Topic
		{
			get 
			{
				if ( _Topic == null)
				{
					_Topic = Topics.GetTopic( TopicId );
				}
				return _Topic ;
			}
			set { _Topic = value;}
		}

		public int ParentId 
		{
			get { 
				if ( _ParentId == 0)
				{
					_ParentId = _PostId;
				}
				return _ParentId; 
			}
			set { _ParentId = (value < 0 ? 0: value);}			
		}		

		public Forum Forum
		{
			get 
			{
				if ( _Forum == null)
				{
					_Forum = Forums.GetForum( ForumId);
				}
				return _Forum ;
			}
			set { _Forum = value;}
		}
	
		public int ForumId			 
		{
			get { return _ForumId ; }
			set { _ForumId = (value < 0 ? 0: value);}			
		}		
	
		public int SortOrder 
		{
			get { return _SortOrder ; }
			set { _SortOrder = (value < 0 ? 0: value);}			
		}	
		
		public string Author 
		{
			get { return _Author; }
			set { _Author = value; }			
		}

		public string Subject 
		{
			get { return _Subject; }
			set { _Subject = value; }			
		}	

		public string Body 
		{
			get { return _Body; }
			set { _Body = value; }		
		}	
	
		public DateTime PostDate 
		{
			get { return _PostDate; }
			set { _PostDate = value; }	
		}	

		public bool IsApproved 
		{
			get { return _IsApproved; }
			set { _IsApproved = value; }	
		}
		
		public object[] ItemArray
		{
			get	
			{
				object[] array = new object[]{
					PostId ,
					TopicId,ParentId,User.NickName,
					User.UserId,ForumId,SortOrder,
					 Subject,PostDate,IsApproved,IsLocked,
					TotalViews,Body,PostLevel,												
				};
				return array;
			}
		}	
	}
}
